// $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/versclibs/data/stan/X_MCB.v,v 1.12 2010/02/04 20:59:13 vandanad Exp $
///////////////////////////////////////////////////////
//  Copyright (c) 2008 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /     Vendor      : Xilinx 
// \  \    \/      Version     : 11.1i 
//  \  \           Description : 
//  /  /                      
// /__/   /\       Filename    : X_MCB.v
// \  \  /  \ 
//  \__\/\__ \                    
//                                 
//  Generated by :	/home/chen/xfoundry/HEAD/env/Databases/CAEInterfaces/LibraryWriters/bin/write_verilog.pl
//  Revision:		1.0
//  1016 - Added memory type based parameter checks and commented the uiclk->ioidrpclk path delay.
//  510782 - Added the uiclk->ioidrpclk path delay back.
//  513339 - Fixed connectivity issue caused by library writer bug.
//  518312 - Set UICLK->IOIDRPCLK specify delay to (0,0).
//  520730 - Remove UICLK-> IOIDRPTRAIN path from specify block.
//  532287 - Change default value of parameter CAL_CALIBRATION_MODE.
//  545576 - MEM_MDDR_ODS attribute update.
///////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module X_MCB (
  ADDR,
  BA,
  CAS,
  CKE,
  DQIOWEN0,
  DQON,
  DQOP,
  DQSIOWEN90N,
  DQSIOWEN90P,
  IOIDRPADD,
  IOIDRPADDR,
  IOIDRPBROADCAST,
  IOIDRPCLK,
  IOIDRPCS,
  IOIDRPSDO,
  IOIDRPTRAIN,
  IOIDRPUPDATE,
  LDMN,
  LDMP,
  ODT,
  P0CMDEMPTY,
  P0CMDFULL,
  P0RDCOUNT,
  P0RDDATA,
  P0RDEMPTY,
  P0RDERROR,
  P0RDFULL,
  P0RDOVERFLOW,
  P0WRCOUNT,
  P0WREMPTY,
  P0WRERROR,
  P0WRFULL,
  P0WRUNDERRUN,
  P1CMDEMPTY,
  P1CMDFULL,
  P1RDCOUNT,
  P1RDDATA,
  P1RDEMPTY,
  P1RDERROR,
  P1RDFULL,
  P1RDOVERFLOW,
  P1WRCOUNT,
  P1WREMPTY,
  P1WRERROR,
  P1WRFULL,
  P1WRUNDERRUN,
  P2CMDEMPTY,
  P2CMDFULL,
  P2COUNT,
  P2EMPTY,
  P2ERROR,
  P2FULL,
  P2RDDATA,
  P2RDOVERFLOW,
  P2WRUNDERRUN,
  P3CMDEMPTY,
  P3CMDFULL,
  P3COUNT,
  P3EMPTY,
  P3ERROR,
  P3FULL,
  P3RDDATA,
  P3RDOVERFLOW,
  P3WRUNDERRUN,
  P4CMDEMPTY,
  P4CMDFULL,
  P4COUNT,
  P4EMPTY,
  P4ERROR,
  P4FULL,
  P4RDDATA,
  P4RDOVERFLOW,
  P4WRUNDERRUN,
  P5CMDEMPTY,
  P5CMDFULL,
  P5COUNT,
  P5EMPTY,
  P5ERROR,
  P5FULL,
  P5RDDATA,
  P5RDOVERFLOW,
  P5WRUNDERRUN,
  RAS,
  RST,
  SELFREFRESHMODE,
  STATUS,
  UDMN,
  UDMP,
  UOCALSTART,
  UOCMDREADYIN,
  UODATA,
  UODATAVALID,
  UODONECAL,
  UOREFRSHFLAG,
  UOSDO,
  WE,
  DQI,
  DQSIOIN,
  DQSIOIP,
  IOIDRPSDI,
  P0ARBEN,
  P0CMDBA,
  P0CMDBL,
  P0CMDCA,
  P0CMDCLK,
  P0CMDEN,
  P0CMDINSTR,
  P0CMDRA,
  P0RDCLK,
  P0RDEN,
  P0RWRMASK,
  P0WRCLK,
  P0WRDATA,
  P0WREN,
  P1ARBEN,
  P1CMDBA,
  P1CMDBL,
  P1CMDCA,
  P1CMDCLK,
  P1CMDEN,
  P1CMDINSTR,
  P1CMDRA,
  P1RDCLK,
  P1RDEN,
  P1RWRMASK,
  P1WRCLK,
  P1WRDATA,
  P1WREN,
  P2ARBEN,
  P2CLK,
  P2CMDBA,
  P2CMDBL,
  P2CMDCA,
  P2CMDCLK,
  P2CMDEN,
  P2CMDINSTR,
  P2CMDRA,
  P2EN,
  P2WRDATA,
  P2WRMASK,
  P3ARBEN,
  P3CLK,
  P3CMDBA,
  P3CMDBL,
  P3CMDCA,
  P3CMDCLK,
  P3CMDEN,
  P3CMDINSTR,
  P3CMDRA,
  P3EN,
  P3WRDATA,
  P3WRMASK,
  P4ARBEN,
  P4CLK,
  P4CMDBA,
  P4CMDBL,
  P4CMDCA,
  P4CMDCLK,
  P4CMDEN,
  P4CMDINSTR,
  P4CMDRA,
  P4EN,
  P4WRDATA,
  P4WRMASK,
  P5ARBEN,
  P5CLK,
  P5CMDBA,
  P5CMDBL,
  P5CMDCA,
  P5CMDCLK,
  P5CMDEN,
  P5CMDINSTR,
  P5CMDRA,
  P5EN,
  P5WRDATA,
  P5WRMASK,
  PLLCE,
  PLLCLK,
  PLLLOCK,
  RECAL,
  SELFREFRESHENTER,
  SYSRST,
  UDQSIOIN,
  UDQSIOIP,
  UIADD,
  UIADDR,
  UIBROADCAST,
  UICLK,
  UICMD,
  UICMDEN,
  UICMDIN,
  UICS,
  UIDONECAL,
  UIDQCOUNT,
  UIDQLOWERDEC,
  UIDQLOWERINC,
  UIDQUPPERDEC,
  UIDQUPPERINC,
  UIDRPUPDATE,
  UILDQSDEC,
  UILDQSINC,
  UIREAD,
  UISDI,
  UIUDQSDEC,
  UIUDQSINC
);

  parameter LOC = "UNPLACED";
  parameter integer ARB_NUM_TIME_SLOTS = 12;
  parameter [17:0] ARB_TIME_SLOT_0 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_1 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_10 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_11 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_2 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_3 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_4 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_5 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_6 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_7 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_8 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_9 = 18'b111111111111111111;
  parameter [2:0] CAL_BA = 3'h0;
  parameter CAL_BYPASS = "YES";
  parameter [11:0] CAL_CA = 12'h000;
  parameter CAL_CALIBRATION_MODE = "NOCALIBRATION";
  parameter integer CAL_CLK_DIV = 1;
  parameter CAL_DELAY = "QUARTER";
  parameter [14:0] CAL_RA = 15'h0000;
  parameter MEM_ADDR_ORDER = "BANK_ROW_COLUMN";
  parameter integer MEM_BA_SIZE = 3;
  parameter integer MEM_BURST_LEN = 8;
  parameter integer MEM_CAS_LATENCY = 4;
  parameter integer MEM_CA_SIZE = 11;
  parameter MEM_DDR1_2_ODS = "FULL";
  parameter MEM_DDR2_3_HIGH_TEMP_SR = "NORMAL";
  parameter MEM_DDR2_3_PA_SR = "FULL";
  parameter integer MEM_DDR2_ADD_LATENCY = 0;
  parameter MEM_DDR2_DIFF_DQS_EN = "YES";
  parameter MEM_DDR2_RTT = "50OHMS";
  parameter integer MEM_DDR2_WRT_RECOVERY = 4;
  parameter MEM_DDR3_ADD_LATENCY = "OFF";
  parameter MEM_DDR3_AUTO_SR = "ENABLED";
  parameter integer MEM_DDR3_CAS_LATENCY = 7;
  parameter integer MEM_DDR3_CAS_WR_LATENCY = 5;
  parameter MEM_DDR3_DYN_WRT_ODT = "OFF";
  parameter MEM_DDR3_ODS = "DIV7";
  parameter MEM_DDR3_RTT = "DIV2";
  parameter integer MEM_DDR3_WRT_RECOVERY = 7;
  parameter MEM_MDDR_ODS = "FULL";
  parameter MEM_MOBILE_PA_SR = "FULL";
  parameter integer MEM_MOBILE_TC_SR = 0;
  parameter integer MEM_RAS_VAL = 0;
  parameter integer MEM_RA_SIZE = 13;
  parameter integer MEM_RCD_VAL = 1;
  parameter integer MEM_REFI_VAL = 0;
  parameter integer MEM_RFC_VAL = 0;
  parameter integer MEM_RP_VAL = 0;
  parameter integer MEM_RTP_VAL = 0;
  parameter MEM_TYPE = "DDR3";
  parameter integer MEM_WIDTH = 4;
  parameter integer MEM_WR_VAL = 0;
  parameter integer MEM_WTR_VAL = 3;
  parameter PORT_CONFIG = "B32_B32_B32_B32";
  
  localparam in_delay = 0;
  localparam out_delay = 0;
  localparam INCLK_DELAY = 0;
  localparam OUTCLK_DELAY = 0;

  output CAS;
  output CKE;
  output DQIOWEN0;
  output DQSIOWEN90N;
  output DQSIOWEN90P;
  output IOIDRPADD;
  output IOIDRPBROADCAST;
  output IOIDRPCLK;
  output IOIDRPCS;
  output IOIDRPSDO;
  output IOIDRPTRAIN;
  output IOIDRPUPDATE;
  output LDMN;
  output LDMP;
  output ODT;
  output P0CMDEMPTY;
  output P0CMDFULL;
  output P0RDEMPTY;
  output P0RDERROR;
  output P0RDFULL;
  output P0RDOVERFLOW;
  output P0WREMPTY;
  output P0WRERROR;
  output P0WRFULL;
  output P0WRUNDERRUN;
  output P1CMDEMPTY;
  output P1CMDFULL;
  output P1RDEMPTY;
  output P1RDERROR;
  output P1RDFULL;
  output P1RDOVERFLOW;
  output P1WREMPTY;
  output P1WRERROR;
  output P1WRFULL;
  output P1WRUNDERRUN;
  output P2CMDEMPTY;
  output P2CMDFULL;
  output P2EMPTY;
  output P2ERROR;
  output P2FULL;
  output P2RDOVERFLOW;
  output P2WRUNDERRUN;
  output P3CMDEMPTY;
  output P3CMDFULL;
  output P3EMPTY;
  output P3ERROR;
  output P3FULL;
  output P3RDOVERFLOW;
  output P3WRUNDERRUN;
  output P4CMDEMPTY;
  output P4CMDFULL;
  output P4EMPTY;
  output P4ERROR;
  output P4FULL;
  output P4RDOVERFLOW;
  output P4WRUNDERRUN;
  output P5CMDEMPTY;
  output P5CMDFULL;
  output P5EMPTY;
  output P5ERROR;
  output P5FULL;
  output P5RDOVERFLOW;
  output P5WRUNDERRUN;
  output RAS;
  output RST;
  output SELFREFRESHMODE;
  output UDMN;
  output UDMP;
  output UOCALSTART;
  output UOCMDREADYIN;
  output UODATAVALID;
  output UODONECAL;
  output UOREFRSHFLAG;
  output UOSDO;
  output WE;
  output [14:0] ADDR;
  output [15:0] DQON;
  output [15:0] DQOP;
  output [2:0] BA;
  output [31:0] P0RDDATA;
  output [31:0] P1RDDATA;
  output [31:0] P2RDDATA;
  output [31:0] P3RDDATA;
  output [31:0] P4RDDATA;
  output [31:0] P5RDDATA;
  output [31:0] STATUS;
  output [4:0] IOIDRPADDR;
  output [6:0] P0RDCOUNT;
  output [6:0] P0WRCOUNT;
  output [6:0] P1RDCOUNT;
  output [6:0] P1WRCOUNT;
  output [6:0] P2COUNT;
  output [6:0] P3COUNT;
  output [6:0] P4COUNT;
  output [6:0] P5COUNT;
  output [7:0] UODATA;

  input DQSIOIN;
  input DQSIOIP;
  input IOIDRPSDI;
  input P0ARBEN;
  input P0CMDCLK;
  input P0CMDEN;
  input P0RDCLK;
  input P0RDEN;
  input P0WRCLK;
  input P0WREN;
  input P1ARBEN;
  input P1CMDCLK;
  input P1CMDEN;
  input P1RDCLK;
  input P1RDEN;
  input P1WRCLK;
  input P1WREN;
  input P2ARBEN;
  input P2CLK;
  input P2CMDCLK;
  input P2CMDEN;
  input P2EN;
  input P3ARBEN;
  input P3CLK;
  input P3CMDCLK;
  input P3CMDEN;
  input P3EN;
  input P4ARBEN;
  input P4CLK;
  input P4CMDCLK;
  input P4CMDEN;
  input P4EN;
  input P5ARBEN;
  input P5CLK;
  input P5CMDCLK;
  input P5CMDEN;
  input P5EN;
  input PLLLOCK;
  input RECAL;
  input SELFREFRESHENTER;
  input SYSRST;
  input UDQSIOIN;
  input UDQSIOIP;
  input UIADD;
  input UIBROADCAST;
  input UICLK;
  input UICMD;
  input UICMDEN;
  input UICMDIN;
  input UICS;
  input UIDONECAL;
  input UIDQLOWERDEC;
  input UIDQLOWERINC;
  input UIDQUPPERDEC;
  input UIDQUPPERINC;
  input UIDRPUPDATE;
  input UILDQSDEC;
  input UILDQSINC;
  input UIREAD;
  input UISDI;
  input UIUDQSDEC;
  input UIUDQSINC;
  input [11:0] P0CMDCA;
  input [11:0] P1CMDCA;
  input [11:0] P2CMDCA;
  input [11:0] P3CMDCA;
  input [11:0] P4CMDCA;
  input [11:0] P5CMDCA;
  input [14:0] P0CMDRA;
  input [14:0] P1CMDRA;
  input [14:0] P2CMDRA;
  input [14:0] P3CMDRA;
  input [14:0] P4CMDRA;
  input [14:0] P5CMDRA;
  input [15:0] DQI;
  input [1:0] PLLCE;
  input [1:0] PLLCLK;
  input [2:0] P0CMDBA;
  input [2:0] P0CMDINSTR;
  input [2:0] P1CMDBA;
  input [2:0] P1CMDINSTR;
  input [2:0] P2CMDBA;
  input [2:0] P2CMDINSTR;
  input [2:0] P3CMDBA;
  input [2:0] P3CMDINSTR;
  input [2:0] P4CMDBA;
  input [2:0] P4CMDINSTR;
  input [2:0] P5CMDBA;
  input [2:0] P5CMDINSTR;
  input [31:0] P0WRDATA;
  input [31:0] P1WRDATA;
  input [31:0] P2WRDATA;
  input [31:0] P3WRDATA;
  input [31:0] P4WRDATA;
  input [31:0] P5WRDATA;
  input [3:0] P0RWRMASK;
  input [3:0] P1RWRMASK;
  input [3:0] P2WRMASK;
  input [3:0] P3WRMASK;
  input [3:0] P4WRMASK;
  input [3:0] P5WRMASK;
  input [3:0] UIDQCOUNT;
  input [4:0] UIADDR;
  input [5:0] P0CMDBL;
  input [5:0] P1CMDBL;
  input [5:0] P2CMDBL;
  input [5:0] P3CMDBL;
  input [5:0] P4CMDBL;
  input [5:0] P5CMDBL;

  reg ARB_NUM_TIME_SLOTS_BINARY;
  reg CAL_BYPASS_BINARY;
  reg CAL_CALIBRATION_MODE_BINARY;
  reg MEM_ADDR_ORDER_BINARY;
  reg MEM_BA_SIZE_BINARY;
  reg MEM_BURST_LEN_BINARY;
  reg MEM_DDR1_2_ODS_BINARY;
  reg MEM_DDR2_3_HIGH_TEMP_SR_BINARY;
  reg MEM_DDR2_DIFF_DQS_EN_BINARY;
  reg MEM_DDR3_AUTO_SR_BINARY;
  reg [2:0] PORT_CONFIG_BINARY;
  reg [11:0] MEM_REFI_VAL_BINARY;
  reg [17:0] ARB_TIME_SLOT_0_BINARY;
  reg [17:0] ARB_TIME_SLOT_10_BINARY;
  reg [17:0] ARB_TIME_SLOT_11_BINARY;
  reg [17:0] ARB_TIME_SLOT_1_BINARY;
  reg [17:0] ARB_TIME_SLOT_2_BINARY;
  reg [17:0] ARB_TIME_SLOT_3_BINARY;
  reg [17:0] ARB_TIME_SLOT_4_BINARY;
  reg [17:0] ARB_TIME_SLOT_5_BINARY;
  reg [17:0] ARB_TIME_SLOT_6_BINARY;
  reg [17:0] ARB_TIME_SLOT_7_BINARY;
  reg [17:0] ARB_TIME_SLOT_8_BINARY;
  reg [17:0] ARB_TIME_SLOT_9_BINARY;
  reg [1:0] CAL_DELAY_BINARY;
  reg [1:0] MEM_CA_SIZE_BINARY;
  reg [1:0] MEM_DDR2_RTT_BINARY;
  reg [1:0] MEM_DDR3_ADD_LATENCY_BINARY;
  reg [1:0] MEM_DDR3_DYN_WRT_ODT_BINARY;
  reg [1:0] MEM_DDR3_ODS_BINARY;
  reg [1:0] MEM_MOBILE_TC_SR_BINARY;
  reg [1:0] MEM_RA_SIZE_BINARY;
  reg [1:0] MEM_WIDTH_BINARY;
  reg [2:0] CAL_CLK_DIV_BINARY;
  reg [2:0] MEM_CAS_LATENCY_BINARY;
  reg [2:0] MEM_DDR2_3_PA_SR_BINARY;
  reg [2:0] MEM_DDR2_ADD_LATENCY_BINARY;
  reg [2:0] MEM_DDR2_WRT_RECOVERY_BINARY;
  reg [2:0] MEM_DDR3_CAS_WR_LATENCY_BINARY;
  reg [2:0] MEM_DDR3_RTT_BINARY;
  reg [2:0] MEM_DDR3_WRT_RECOVERY_BINARY;
  reg [2:0] MEM_MDDR_ODS_BINARY;
  reg [2:0] MEM_MOBILE_PA_SR_BINARY;
  reg [2:0] MEM_RCD_VAL_BINARY;
  reg [2:0] MEM_RTP_VAL_BINARY;
  reg [2:0] MEM_TYPE_BINARY;
  reg [2:0] MEM_WR_VAL_BINARY;
  reg [2:0] MEM_WTR_VAL_BINARY;
  reg [3:0] MEM_DDR3_CAS_LATENCY_BINARY;
  reg [3:0] MEM_RP_VAL_BINARY;
  reg [4:0] MEM_RAS_VAL_BINARY;
  reg [7:0] MEM_RFC_VAL_BINARY;

  tri0 GSR = glbl.GSR;
  reg notifier;

  wire CAS_OUT;
  wire CKE_OUT;
  wire DQIOWEN0_OUT;
  wire DQSIOWEN90N_OUT;
  wire DQSIOWEN90P_OUT;
  wire IOIDRPADD_OUT;
  wire IOIDRPBROADCAST_OUT;
  wire IOIDRPCLK_OUT;
  wire IOIDRPCS_OUT;
  wire IOIDRPSDO_OUT;
  wire IOIDRPTRAIN_OUT;
  wire IOIDRPUPDATE_OUT;
  wire LDMN_OUT;
  wire LDMP_OUT;
  wire ODT_OUT;
  wire P0CMDEMPTY_OUT;
  wire P0CMDFULL_OUT;
  wire P0RDEMPTY_OUT;
  wire P0RDERROR_OUT;
  wire P0RDFULL_OUT;
  wire P0RDOVERFLOW_OUT;
  wire P0WREMPTY_OUT;
  wire P0WRERROR_OUT;
  wire P0WRFULL_OUT;
  wire P0WRUNDERRUN_OUT;
  wire P1CMDEMPTY_OUT;
  wire P1CMDFULL_OUT;
  wire P1RDEMPTY_OUT;
  wire P1RDERROR_OUT;
  wire P1RDFULL_OUT;
  wire P1RDOVERFLOW_OUT;
  wire P1WREMPTY_OUT;
  wire P1WRERROR_OUT;
  wire P1WRFULL_OUT;
  wire P1WRUNDERRUN_OUT;
  wire P2CMDEMPTY_OUT;
  wire P2CMDFULL_OUT;
  wire P2EMPTY_OUT;
  wire P2ERROR_OUT;
  wire P2FULL_OUT;
  wire P2RDOVERFLOW_OUT;
  wire P2WRUNDERRUN_OUT;
  wire P3CMDEMPTY_OUT;
  wire P3CMDFULL_OUT;
  wire P3EMPTY_OUT;
  wire P3ERROR_OUT;
  wire P3FULL_OUT;
  wire P3RDOVERFLOW_OUT;
  wire P3WRUNDERRUN_OUT;
  wire P4CMDEMPTY_OUT;
  wire P4CMDFULL_OUT;
  wire P4EMPTY_OUT;
  wire P4ERROR_OUT;
  wire P4FULL_OUT;
  wire P4RDOVERFLOW_OUT;
  wire P4WRUNDERRUN_OUT;
  wire P5CMDEMPTY_OUT;
  wire P5CMDFULL_OUT;
  wire P5EMPTY_OUT;
  wire P5ERROR_OUT;
  wire P5FULL_OUT;
  wire P5RDOVERFLOW_OUT;
  wire P5WRUNDERRUN_OUT;
  wire RAS_OUT;
  wire RST_OUT;
  wire SELFREFRESHMODE_OUT;
  wire UDMN_OUT;
  wire UDMP_OUT;
  wire UOCALSTART_OUT;
  wire UOCMDREADYIN_OUT;
  wire UODATAVALID_OUT;
  wire UODONECAL_OUT;
  wire UOREFRSHFLAG_OUT;
  wire UOSDO_OUT;
  wire WE_OUT;
  wire [14:0] ADDR_OUT;
  wire [15:0] DQON_OUT;
  wire [15:0] DQOP_OUT;
  wire [2:0] BA_OUT;
  wire [31:0] P0RDDATA_OUT;
  wire [31:0] P1RDDATA_OUT;
  wire [31:0] P2RDDATA_OUT;
  wire [31:0] P3RDDATA_OUT;
  wire [31:0] P4RDDATA_OUT;
  wire [31:0] P5RDDATA_OUT;
  wire [31:0] STATUS_OUT;
  wire [4:0] IOIDRPADDR_OUT;
  wire [6:0] P0RDCOUNT_OUT;
  wire [6:0] P0WRCOUNT_OUT;
  wire [6:0] P1RDCOUNT_OUT;
  wire [6:0] P1WRCOUNT_OUT;
  wire [6:0] P2COUNT_OUT;
  wire [6:0] P3COUNT_OUT;
  wire [6:0] P4COUNT_OUT;
  wire [6:0] P5COUNT_OUT;
  wire [7:0] UODATA_OUT;

  wire DQSIOIN_IN;
  wire DQSIOIP_IN;
  wire IOIDRPSDI_IN;
  wire P0ARBEN_IN;
  wire P0CMDCLK_IN;
  wire P0CMDEN_IN;
  wire P0RDCLK_IN;
  wire P0RDEN_IN;
  wire P0WRCLK_IN;
  wire P0WREN_IN;
  wire P1ARBEN_IN;
  wire P1CMDCLK_IN;
  wire P1CMDEN_IN;
  wire P1RDCLK_IN;
  wire P1RDEN_IN;
  wire P1WRCLK_IN;
  wire P1WREN_IN;
  wire P2ARBEN_IN;
  wire P2CLK_IN;
  wire P2CMDCLK_IN;
  wire P2CMDEN_IN;
  wire P2EN_IN;
  wire P3ARBEN_IN;
  wire P3CLK_IN;
  wire P3CMDCLK_IN;
  wire P3CMDEN_IN;
  wire P3EN_IN;
  wire P4ARBEN_IN;
  wire P4CLK_IN;
  wire P4CMDCLK_IN;
  wire P4CMDEN_IN;
  wire P4EN_IN;
  wire P5ARBEN_IN;
  wire P5CLK_IN;
  wire P5CMDCLK_IN;
  wire P5CMDEN_IN;
  wire P5EN_IN;
  wire PLLLOCK_IN;
  wire RECAL_IN;
  wire SELFREFRESHENTER_IN;
  wire SYSRST_IN;
  wire UDQSIOIN_IN;
  wire UDQSIOIP_IN;
  wire UIADD_IN;
  wire UIBROADCAST_IN;
  wire UICLK_IN;
  wire UICMDEN_IN;
  wire UICMDIN_IN;
  wire UICMD_IN;
  wire UICS_IN;
  wire UIDONECAL_IN;
  wire UIDQLOWERDEC_IN;
  wire UIDQLOWERINC_IN;
  wire UIDQUPPERDEC_IN;
  wire UIDQUPPERINC_IN;
  wire UIDRPUPDATE_IN;
  wire UILDQSDEC_IN;
  wire UILDQSINC_IN;
  wire UIREAD_IN;
  wire UISDI_IN;
  wire UIUDQSDEC_IN;
  wire UIUDQSINC_IN;
  wire [11:0] P0CMDCA_IN;
  wire [11:0] P1CMDCA_IN;
  wire [11:0] P2CMDCA_IN;
  wire [11:0] P3CMDCA_IN;
  wire [11:0] P4CMDCA_IN;
  wire [11:0] P5CMDCA_IN;
  wire [14:0] P0CMDRA_IN;
  wire [14:0] P1CMDRA_IN;
  wire [14:0] P2CMDRA_IN;
  wire [14:0] P3CMDRA_IN;
  wire [14:0] P4CMDRA_IN;
  wire [14:0] P5CMDRA_IN;
  wire [15:0] DQI_IN;
  wire [1:0] PLLCE_IN;
  wire [1:0] PLLCLK_IN;
  wire [2:0] P0CMDBA_IN;
  wire [2:0] P0CMDINSTR_IN;
  wire [2:0] P1CMDBA_IN;
  wire [2:0] P1CMDINSTR_IN;
  wire [2:0] P2CMDBA_IN;
  wire [2:0] P2CMDINSTR_IN;
  wire [2:0] P3CMDBA_IN;
  wire [2:0] P3CMDINSTR_IN;
  wire [2:0] P4CMDBA_IN;
  wire [2:0] P4CMDINSTR_IN;
  wire [2:0] P5CMDBA_IN;
  wire [2:0] P5CMDINSTR_IN;
  wire [31:0] P0WRDATA_IN;
  wire [31:0] P1WRDATA_IN;
  wire [31:0] P2WRDATA_IN;
  wire [31:0] P3WRDATA_IN;
  wire [31:0] P4WRDATA_IN;
  wire [31:0] P5WRDATA_IN;
  wire [3:0] P0RWRMASK_IN;
  wire [3:0] P1RWRMASK_IN;
  wire [3:0] P2WRMASK_IN;
  wire [3:0] P3WRMASK_IN;
  wire [3:0] P4WRMASK_IN;
  wire [3:0] P5WRMASK_IN;
  wire [3:0] UIDQCOUNT_IN;
  wire [4:0] UIADDR_IN;
  wire [5:0] P0CMDBL_IN;
  wire [5:0] P1CMDBL_IN;
  wire [5:0] P2CMDBL_IN;
  wire [5:0] P3CMDBL_IN;
  wire [5:0] P4CMDBL_IN;
  wire [5:0] P5CMDBL_IN;
  wire DQSIOIN_INDELAY;
  wire DQSIOIP_INDELAY;
  wire IOIDRPSDI_INDELAY;
  wire P0ARBEN_INDELAY;
  wire P0CMDCLK_INDELAY;
  wire P0CMDEN_INDELAY;
  wire P0RDCLK_INDELAY;
  wire P0RDEN_INDELAY;
  wire P0WRCLK_INDELAY;
  wire P0WREN_INDELAY;
  wire P1ARBEN_INDELAY;
  wire P1CMDCLK_INDELAY;
  wire P1CMDEN_INDELAY;
  wire P1RDCLK_INDELAY;
  wire P1RDEN_INDELAY;
  wire P1WRCLK_INDELAY;
  wire P1WREN_INDELAY;
  wire P2ARBEN_INDELAY;
  wire P2CLK_INDELAY;
  wire P2CMDCLK_INDELAY;
  wire P2CMDEN_INDELAY;
  wire P2EN_INDELAY;
  wire P3ARBEN_INDELAY;
  wire P3CLK_INDELAY;
  wire P3CMDCLK_INDELAY;
  wire P3CMDEN_INDELAY;
  wire P3EN_INDELAY;
  wire P4ARBEN_INDELAY;
  wire P4CLK_INDELAY;
  wire P4CMDCLK_INDELAY;
  wire P4CMDEN_INDELAY;
  wire P4EN_INDELAY;
  wire P5ARBEN_INDELAY;
  wire P5CLK_INDELAY;
  wire P5CMDCLK_INDELAY;
  wire P5CMDEN_INDELAY;
  wire P5EN_INDELAY;
  wire PLLLOCK_INDELAY;
  wire RECAL_INDELAY;
  wire SELFREFRESHENTER_INDELAY;
  wire SYSRST_INDELAY;
  wire UDQSIOIN_INDELAY;
  wire UDQSIOIP_INDELAY;
  wire UIADD_INDELAY;
  wire UIBROADCAST_INDELAY;
  wire UICLK_INDELAY;
  wire UICMDEN_INDELAY;
  wire UICMDIN_INDELAY;
  wire UICMD_INDELAY;
  wire UICS_INDELAY;
  wire UIDONECAL_INDELAY;
  wire UIDQLOWERDEC_INDELAY;
  wire UIDQLOWERINC_INDELAY;
  wire UIDQUPPERDEC_INDELAY;
  wire UIDQUPPERINC_INDELAY;
  wire UIDRPUPDATE_INDELAY;
  wire UILDQSDEC_INDELAY;
  wire UILDQSINC_INDELAY;
  wire UIREAD_INDELAY;
  wire UISDI_INDELAY;
  wire UIUDQSDEC_INDELAY;
  wire UIUDQSINC_INDELAY;
  wire [11:0] P0CMDCA_INDELAY;
  wire [11:0] P1CMDCA_INDELAY;
  wire [11:0] P2CMDCA_INDELAY;
  wire [11:0] P3CMDCA_INDELAY;
  wire [11:0] P4CMDCA_INDELAY;
  wire [11:0] P5CMDCA_INDELAY;
  wire [14:0] P0CMDRA_INDELAY;
  wire [14:0] P1CMDRA_INDELAY;
  wire [14:0] P2CMDRA_INDELAY;
  wire [14:0] P3CMDRA_INDELAY;
  wire [14:0] P4CMDRA_INDELAY;
  wire [14:0] P5CMDRA_INDELAY;
  wire [15:0] DQI_INDELAY;
  wire [1:0] PLLCE_INDELAY;
  wire [1:0] PLLCLK_INDELAY;
  wire [2:0] P0CMDBA_INDELAY;
  wire [2:0] P0CMDINSTR_INDELAY;
  wire [2:0] P1CMDBA_INDELAY;
  wire [2:0] P1CMDINSTR_INDELAY;
  wire [2:0] P2CMDBA_INDELAY;
  wire [2:0] P2CMDINSTR_INDELAY;
  wire [2:0] P3CMDBA_INDELAY;
  wire [2:0] P3CMDINSTR_INDELAY;
  wire [2:0] P4CMDBA_INDELAY;
  wire [2:0] P4CMDINSTR_INDELAY;
  wire [2:0] P5CMDBA_INDELAY;
  wire [2:0] P5CMDINSTR_INDELAY;
  wire [31:0] P0WRDATA_INDELAY;
  wire [31:0] P1WRDATA_INDELAY;
  wire [31:0] P2WRDATA_INDELAY;
  wire [31:0] P3WRDATA_INDELAY;
  wire [31:0] P4WRDATA_INDELAY;
  wire [31:0] P5WRDATA_INDELAY;
  wire [3:0] P0RWRMASK_INDELAY;
  wire [3:0] P1RWRMASK_INDELAY;
  wire [3:0] P2WRMASK_INDELAY;
  wire [3:0] P3WRMASK_INDELAY;
  wire [3:0] P4WRMASK_INDELAY;
  wire [3:0] P5WRMASK_INDELAY;
  wire [3:0] UIDQCOUNT_INDELAY;
  wire [4:0] UIADDR_INDELAY;
  wire [5:0] P0CMDBL_INDELAY;
  wire [5:0] P1CMDBL_INDELAY;
  wire [5:0] P2CMDBL_INDELAY;
  wire [5:0] P3CMDBL_INDELAY;
  wire [5:0] P4CMDBL_INDELAY;
  wire [5:0] P5CMDBL_INDELAY;

  initial begin
    case (ARB_NUM_TIME_SLOTS)
      12 : ARB_NUM_TIME_SLOTS_BINARY = 1'b1;
      10 : ARB_NUM_TIME_SLOTS_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute ARB_NUM_TIME_SLOTS on X_MCB instance %m is set to %d.  Legal values for this attribute are 12 or 10.", ARB_NUM_TIME_SLOTS);
        $finish;
      end
    endcase

    case (CAL_BYPASS)
      "YES" : CAL_BYPASS_BINARY = 1'b1;
      "NO" : CAL_BYPASS_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_BYPASS on X_MCB instance %m is set to %s.  Legal values for this attribute are YES, or NO.", CAL_BYPASS);
        $finish;
      end
    endcase

    case (CAL_CALIBRATION_MODE)
      "CALIBRATION" : CAL_CALIBRATION_MODE_BINARY = 1'b0;
      "NOCALIBRATION" : CAL_CALIBRATION_MODE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_CALIBRATION_MODE on X_MCB instance %m is set to %s.  Legal values for this attribute are CALIBRATION, or NOCALIBRATION.", CAL_CALIBRATION_MODE);
        $finish;
      end
    endcase

    case (CAL_CLK_DIV)
      1 : CAL_CLK_DIV_BINARY = 3'b000;
      2 : CAL_CLK_DIV_BINARY = 3'b001;
      4 : CAL_CLK_DIV_BINARY = 3'b010;
      8 : CAL_CLK_DIV_BINARY = 3'b011;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_CLK_DIV on X_MCB instance %m is set to %d.  Legal values for this attribute are 1, 2, 4 or 8.", CAL_CLK_DIV);
        $finish;
      end
    endcase

    case (CAL_DELAY)
      "QUARTER" : CAL_DELAY_BINARY = 2'b00;
      "FULL" : CAL_DELAY_BINARY = 2'b11;
      "HALF" : CAL_DELAY_BINARY = 2'b01;
      "THREEQUARTER" : CAL_DELAY_BINARY = 2'b10;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_DELAY on X_MCB instance %m is set to %s.  Legal values for this attribute are QUARTER, FULL, HALF, or THREEQUARTER.", CAL_DELAY);
        $finish;
      end
    endcase

    case (MEM_ADDR_ORDER)
      "BANK_ROW_COLUMN" : MEM_ADDR_ORDER_BINARY = 1'b0;
      "ROW_BANK_COLUMN" : MEM_ADDR_ORDER_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_ADDR_ORDER on X_MCB instance %m is set to %s.  Legal values for this attribute are BANK_ROW_COLUMN, or ROW_BANK_COLUMN.", MEM_ADDR_ORDER);
        $finish;
      end
    endcase

    case (MEM_BA_SIZE)
      3 : MEM_BA_SIZE_BINARY = 1'b1;
      2 : MEM_BA_SIZE_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_BA_SIZE on X_MCB instance %m is set to %d.  Legal values for this attribute are 2 to 3 .", MEM_BA_SIZE);
        $finish;
      end
    endcase

    case (MEM_CA_SIZE)
      11 : MEM_CA_SIZE_BINARY = 2'b10;
      9 : MEM_CA_SIZE_BINARY = 2'b00;
      10 : MEM_CA_SIZE_BINARY = 2'b01;
      12 : MEM_CA_SIZE_BINARY = 2'b11;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_CA_SIZE on X_MCB instance %m is set to %d.  Legal values for this attribute are 9 to 12.", MEM_CA_SIZE);
        $finish;
      end
    endcase
     case (MEM_TYPE)
      "DDR3" : MEM_TYPE_BINARY = 3'b000;
      "DDR" : MEM_TYPE_BINARY = 3'b010;
      "DDR2" : MEM_TYPE_BINARY = 3'b001;
      "MDDR" : MEM_TYPE_BINARY = 3'b011;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_TYPE on X_MCB instance %m is set to %s.  Legal values for this attribute are DDR3, DDR, DDR2, or MDDR.", MEM_TYPE);
        $finish;
      end
    endcase

    case (MEM_WIDTH)
      4 : MEM_WIDTH_BINARY = 2'b01;
      8 : MEM_WIDTH_BINARY = 2'b10;
      16 : MEM_WIDTH_BINARY = 2'b11;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_WIDTH on X_MCB instance %m is set to %d.  Legal values for this attribute are 4, 8 or 16.", MEM_WIDTH);
        $finish;
      end
    endcase

    case(MEM_BURST_LEN)
      4  : if(MEM_TYPE ==  "DDR3") begin
                 $display("Attribute Syntax Error : The Attribute MEM_BURST_LEN on MEMC instance %m is set to %s.  This parameter cannot be set to 4 for MEM_TYPE DDR3.", MEM_BURST_LEN);
                 $finish;
               end
               else
               MEM_BURST_LEN_BINARY = 3'b010;
      8  : MEM_BURST_LEN_BINARY = 3'b011;
      default : begin
       $display("Attribute Syntax Error : The Attribute MEM_BURST_LEN on MEMC instance %m is set to %s.  Legal values for this attribute are 2, 4 and 8.", MEM_BURST_LEN);
       $finish;
      end
    endcase

    if((MEM_TYPE == "DDR2") || (MEM_TYPE == "DDR")) begin
      case (MEM_DDR1_2_ODS)
      "FULL" : MEM_DDR1_2_ODS_BINARY = 1'b0;
      "REDUCED" : MEM_DDR1_2_ODS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR1_2_ODS on X_MCB instance %m is set to %s.  Legal values for this attribute are FULL, or REDUCED.", MEM_DDR1_2_ODS);
        $finish;
      end
      endcase
    end

    if((MEM_TYPE == "DDR2") || (MEM_TYPE == "DDR3")) begin
      case (MEM_DDR2_3_HIGH_TEMP_SR)
      "NORMAL" : MEM_DDR2_3_HIGH_TEMP_SR_BINARY = 1'b0;
      "EXTENDED" : MEM_DDR2_3_HIGH_TEMP_SR_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_3_HIGH_TEMP_SR on X_MCB instance %m is set to %s.  Legal values for this attribute are NORMAL, or EXTENDED.", MEM_DDR2_3_HIGH_TEMP_SR);
        $finish;
      end
      endcase

      case (MEM_DDR2_3_PA_SR)
      "FULL" : MEM_DDR2_3_PA_SR_BINARY = 3'b000;
      "EIGHTH1" : MEM_DDR2_3_PA_SR_BINARY = 3'b011;
      "EIGHTH2" : MEM_DDR2_3_PA_SR_BINARY = 3'b111;
      "HALF1" : MEM_DDR2_3_PA_SR_BINARY = 3'b001;
      "HALF2" : MEM_DDR2_3_PA_SR_BINARY = 3'b101;
      "QUARTER1" : MEM_DDR2_3_PA_SR_BINARY = 3'b010;
      "QUARTER2" : MEM_DDR2_3_PA_SR_BINARY = 3'b110;
      "THREEQUARTER" : MEM_DDR2_3_PA_SR_BINARY = 3'b100;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_3_PA_SR on X_MCB instance %m is set to %s.  Legal values for this attribute are FULL, EIGHTH1, EIGHTH2, HALF1, HALF2, QUARTER1, QUARTER2, or THREEQUARTER.", MEM_DDR2_3_PA_SR);
        $finish;
      end
      endcase
    end
   
    if (MEM_TYPE == "DDR2") begin
      case (MEM_DDR2_DIFF_DQS_EN)
      "YES" : MEM_DDR2_DIFF_DQS_EN_BINARY = 1'b0;
      "NO" : MEM_DDR2_DIFF_DQS_EN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_DIFF_DQS_EN on X_MCB instance %m is set to %s.  Legal values for this attribute are YES, or NO.", MEM_DDR2_DIFF_DQS_EN);
        $finish;
      end
      endcase

      case (MEM_DDR2_RTT)
      "50OHMS" : MEM_DDR2_RTT_BINARY = 2'b11;
      "75OHMS" : MEM_DDR2_RTT_BINARY = 2'b01;
      "150OHMS" : MEM_DDR2_RTT_BINARY = 2'b10;
      "OFF" : MEM_DDR2_RTT_BINARY = 2'b00;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_RTT on X_MCB instance %m is set to %s.  Legal values for this attribute are 50OHMS, 75OHMS, 150OHMS, or OFF.", MEM_DDR2_RTT);
        $finish;
      end
      endcase

      case (MEM_DDR2_WRT_RECOVERY)
      4 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b011;
      2 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b001;
      3 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b010;
      5 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b100;
      6 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b101;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_WRT_RECOVERY on X_MCB instance %m is set to %d.  Legal values for this attribute are 2 to 6.", MEM_DDR2_WRT_RECOVERY);
        $finish;
      end
      endcase
      if ((MEM_DDR2_ADD_LATENCY >= 0) && (MEM_DDR2_ADD_LATENCY <= 5))
      MEM_DDR2_ADD_LATENCY_BINARY = MEM_DDR2_ADD_LATENCY;
      else begin
      $display("Attribute Syntax Error : The Attribute MEM_DDR2_ADD_LATENCY on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 5.", MEM_DDR2_ADD_LATENCY);
      $finish;
      end
    end 

    if (MEM_TYPE == "DDR3") begin
      case (MEM_DDR3_ADD_LATENCY)
      "OFF" : MEM_DDR3_ADD_LATENCY_BINARY = 2'b00;
      "CL1" : MEM_DDR3_ADD_LATENCY_BINARY = 2'b01;
      "CL2" : MEM_DDR3_ADD_LATENCY_BINARY = 2'b10;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_ADD_LATENCY on X_MCB instance %m is set to %s.  Legal values for this attribute are OFF, CL1, or CL2.", MEM_DDR3_ADD_LATENCY);
        $finish;
      end
      endcase

      case (MEM_DDR3_AUTO_SR)
      "ENABLED" : MEM_DDR3_AUTO_SR_BINARY = 1'b1;
      "MANUAL" : MEM_DDR3_AUTO_SR_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_AUTO_SR on X_MCB instance %m is set to %s.  Legal values for this attribute are ENABLED, or MANUAL.", MEM_DDR3_AUTO_SR);
        $finish;
      end
      endcase

      case (MEM_DDR3_CAS_LATENCY)
      7 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b0110;
      5 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b0010;
      6 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b0100;
      8 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b1000;
      9 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b1010;
      10 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b1100;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_CAS_LATENCY on X_MCB instance %m is set to %d.  Legal values for this attribute are 5 to 10.", MEM_DDR3_CAS_LATENCY);
        $finish;
      end
      endcase

      case (MEM_DDR3_CAS_WR_LATENCY)
      5 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b000;
      6 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b001;
      7 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b010;
      8 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b011;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_CAS_WR_LATENCY on X_MCB instance %m is set to %d.  Legal values for this attribute are 5 to 8.", MEM_DDR3_CAS_WR_LATENCY);
        $finish;
      end
      endcase

      case (MEM_DDR3_DYN_WRT_ODT)
      "OFF" : MEM_DDR3_DYN_WRT_ODT_BINARY = 2'b00;
      "DIV2" : MEM_DDR3_DYN_WRT_ODT_BINARY = 2'b01;
      "DIV4" : MEM_DDR3_DYN_WRT_ODT_BINARY = 2'b10;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_DYN_WRT_ODT on X_MCB instance %m is set to %s.  Legal values for this attribute are OFF, DIV2, or DIV4.", MEM_DDR3_DYN_WRT_ODT);
        $finish;
      end
      endcase

      case (MEM_DDR3_ODS)
      "DIV7" : MEM_DDR3_ODS_BINARY = 2'b01;
      "DIV6" : MEM_DDR3_ODS_BINARY = 2'b00;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_ODS on X_MCB instance %m is set to %s.  Legal values for this attribute are DIV7, or DIV6.", MEM_DDR3_ODS);
        $finish;
      end
      endcase

      case (MEM_DDR3_RTT)
      "DIV2" : MEM_DDR3_RTT_BINARY = 3'b010;
      "DIV4" : MEM_DDR3_RTT_BINARY = 3'b001;
      "DIV6" : MEM_DDR3_RTT_BINARY = 3'b011;
      "DIV8" : MEM_DDR3_RTT_BINARY = 3'b100;
      "DIV12" : MEM_DDR3_RTT_BINARY = 3'b101;
      "OFF" : MEM_DDR3_RTT_BINARY = 3'b000;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_RTT on X_MCB instance %m is set to %s.  Legal values for this attribute are DIV2, DIV4, DIV6, DIV8, DIV12, or OFF.", MEM_DDR3_RTT);
        $finish;
      end
      endcase

      case (MEM_DDR3_WRT_RECOVERY)
      7 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b011;
      5 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b001;
      6 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b010;
      8 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b100;
      10 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b101;
      12 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b110;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_WRT_RECOVERY on X_MCB instance %m is set to %d.  Legal values for this attribute are 5, 6, 7, 8, 10 or 12.", MEM_DDR3_WRT_RECOVERY);
        $finish;
      end
      endcase
    end
    
    if(MEM_TYPE == "MDDR") begin
      case (MEM_MDDR_ODS)
      "FULL" : MEM_MDDR_ODS_BINARY = 3'b000;
      "HALF" : MEM_MDDR_ODS_BINARY = 3'b001;
      "QUARTER" : MEM_MDDR_ODS_BINARY = 3'b010;
      "THREEQUARTERS" : MEM_MDDR_ODS_BINARY = 3'b100;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_MDDR_ODS on X_MCB instance %m is set to %s.  Legal values for this attribute are FULL, HALF, QUARTER, or THREEQUARTERS.", MEM_MDDR_ODS);
        $finish;
      end
      endcase

      case (MEM_MOBILE_PA_SR)
      "FULL" : MEM_MOBILE_PA_SR_BINARY = 3'b000;
      "HALF" : MEM_MOBILE_PA_SR_BINARY = 3'b001;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_MOBILE_PA_SR on X_MCB instance %m is set to %s.  Legal values for this attribute are FULL, or HALF.", MEM_MOBILE_PA_SR);
        $finish;
      end
      endcase
      if ((MEM_MOBILE_TC_SR >= 0) && (MEM_MOBILE_TC_SR <= 3))
      MEM_MOBILE_TC_SR_BINARY = MEM_MOBILE_TC_SR;
      else begin
      $display("Attribute Syntax Error : The Attribute MEM_MOBILE_TC_SR on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 3.", MEM_MOBILE_TC_SR);
      $finish;
      end
    end

    case (MEM_RA_SIZE)
      13 : MEM_RA_SIZE_BINARY = 2'b01;
      12 : MEM_RA_SIZE_BINARY = 2'b00;
      14 : MEM_RA_SIZE_BINARY = 2'b10;
      15 : MEM_RA_SIZE_BINARY = 2'b11;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_RA_SIZE on X_MCB instance %m is set to %d.  Legal values for this attribute are 12 to 15.", MEM_RA_SIZE);
        $finish;
      end
    endcase

   if ((MEM_CAS_LATENCY >= 1) && (MEM_CAS_LATENCY <= 6))
      MEM_CAS_LATENCY_BINARY = MEM_CAS_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_CAS_LATENCY on X_MCB instance %m is set to %d.  Legal values for this attribute are  1 to 6.", MEM_CAS_LATENCY);
      $finish;
    end
   
    if ((MEM_RAS_VAL >= 0) && (MEM_RAS_VAL <= 31))
      MEM_RAS_VAL_BINARY = MEM_RAS_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RAS_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 31.", MEM_RAS_VAL);
      $finish;
    end

    if ((MEM_RCD_VAL >= 0) && (MEM_RCD_VAL <= 7))
      MEM_RCD_VAL_BINARY = MEM_RCD_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RCD_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_RCD_VAL);
      $finish;
    end

    if ((MEM_REFI_VAL >= 0) && (MEM_REFI_VAL <= 4095))
      MEM_REFI_VAL_BINARY = MEM_REFI_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_REFI_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 4095.", MEM_REFI_VAL);
      $finish;
    end

    if ((MEM_RFC_VAL >= 0) && (MEM_RFC_VAL <= 255))
      MEM_RFC_VAL_BINARY = MEM_RFC_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RFC_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 255.", MEM_RFC_VAL);
      $finish;
    end

    if ((MEM_RP_VAL >= 0) && (MEM_RP_VAL <= 15))
      MEM_RP_VAL_BINARY = MEM_RP_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RP_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 15.", MEM_RP_VAL);
      $finish;
    end

    if ((MEM_RTP_VAL >= 0) && (MEM_RTP_VAL <= 7))
      MEM_RTP_VAL_BINARY = MEM_RTP_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RTP_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_RTP_VAL);
      $finish;
    end

    if ((MEM_WR_VAL >= 0) && (MEM_WR_VAL <= 7))
      MEM_WR_VAL_BINARY = MEM_WR_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_WR_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_WR_VAL);
      $finish;
    end

    if ((MEM_WTR_VAL >= 0) && (MEM_WTR_VAL <= 7))
      MEM_WTR_VAL_BINARY = MEM_WTR_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_WTR_VAL on X_MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_WTR_VAL);
      $finish;
    end
     case (PORT_CONFIG)
      "B32_B32_B32_B32" : PORT_CONFIG_BINARY = 3'b001;
      "B32_B32_R32_R32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_R32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_R32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_R32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B64_B32_B32" : PORT_CONFIG_BINARY = 3'b010;
      "B64_B64" : PORT_CONFIG_BINARY = 3'b011;
      "B128" : PORT_CONFIG_BINARY = 3'b100;
      default : begin
        $display("Attribute Syntax Error : The Attribute PORT_CONFIG on X_MCB instance %m is set to %s.  Legal values for this attribute are B32_B32_B32_B32, B32_B32_R32_R32_R32_R32, B32_B32_R32_R32_R32_W32, B32_B32_R32_R32_W32_R32, B32_B32_R32_R32_W32_W32, B32_B32_R32_W32_R32_R32, B32_B32_R32_W32_R32_W32, B32_B32_R32_W32_W32_R32, B32_B32_R32_W32_W32_W32, B32_B32_W32_R32_R32_R32, B32_B32_W32_R32_R32_W32, B32_B32_W32_R32_W32_R32, B32_B32_W32_R32_W32_W32, B32_B32_W32_W32_R32_R32, B32_B32_W32_W32_R32_W32, B32_B32_W32_W32_W32_R32, B32_B32_W32_W32_W32_W32, B64_B32_B32, B64_B64, or B128.", PORT_CONFIG);
        $finish;
      end
    endcase
  end
 
  buf B_ADDR0 (ADDR[0], ADDR_OUT[0]);
  buf B_ADDR1 (ADDR[1], ADDR_OUT[1]);
  buf B_ADDR10 (ADDR[10], ADDR_OUT[10]);
  buf B_ADDR11 (ADDR[11], ADDR_OUT[11]);
  buf B_ADDR12 (ADDR[12], ADDR_OUT[12]);
  buf B_ADDR13 (ADDR[13], ADDR_OUT[13]);
  buf B_ADDR14 (ADDR[14], ADDR_OUT[14]);
  buf B_ADDR2 (ADDR[2], ADDR_OUT[2]);
  buf B_ADDR3 (ADDR[3], ADDR_OUT[3]);
  buf B_ADDR4 (ADDR[4], ADDR_OUT[4]);
  buf B_ADDR5 (ADDR[5], ADDR_OUT[5]);
  buf B_ADDR6 (ADDR[6], ADDR_OUT[6]);
  buf B_ADDR7 (ADDR[7], ADDR_OUT[7]);
  buf B_ADDR8 (ADDR[8], ADDR_OUT[8]);
  buf B_ADDR9 (ADDR[9], ADDR_OUT[9]);
  buf B_BA0 (BA[0], BA_OUT[0]);
  buf B_BA1 (BA[1], BA_OUT[1]);
  buf B_BA2 (BA[2], BA_OUT[2]);
  buf B_CAS (CAS, CAS_OUT);
  buf B_CKE (CKE, CKE_OUT);
  buf B_DQIOWEN0 (DQIOWEN0, DQIOWEN0_OUT);
  buf B_DQON0 (DQON[0], DQON_OUT[0]);
  buf B_DQON1 (DQON[1], DQON_OUT[1]);
  buf B_DQON10 (DQON[10], DQON_OUT[10]);
  buf B_DQON11 (DQON[11], DQON_OUT[11]);
  buf B_DQON12 (DQON[12], DQON_OUT[12]);
  buf B_DQON13 (DQON[13], DQON_OUT[13]);
  buf B_DQON14 (DQON[14], DQON_OUT[14]);
  buf B_DQON15 (DQON[15], DQON_OUT[15]);
  buf B_DQON2 (DQON[2], DQON_OUT[2]);
  buf B_DQON3 (DQON[3], DQON_OUT[3]);
  buf B_DQON4 (DQON[4], DQON_OUT[4]);
  buf B_DQON5 (DQON[5], DQON_OUT[5]);
  buf B_DQON6 (DQON[6], DQON_OUT[6]);
  buf B_DQON7 (DQON[7], DQON_OUT[7]);
  buf B_DQON8 (DQON[8], DQON_OUT[8]);
  buf B_DQON9 (DQON[9], DQON_OUT[9]);
  buf B_DQOP0 (DQOP[0], DQOP_OUT[0]);
  buf B_DQOP1 (DQOP[1], DQOP_OUT[1]);
  buf B_DQOP10 (DQOP[10], DQOP_OUT[10]);
  buf B_DQOP11 (DQOP[11], DQOP_OUT[11]);
  buf B_DQOP12 (DQOP[12], DQOP_OUT[12]);
  buf B_DQOP13 (DQOP[13], DQOP_OUT[13]);
  buf B_DQOP14 (DQOP[14], DQOP_OUT[14]);
  buf B_DQOP15 (DQOP[15], DQOP_OUT[15]);
  buf B_DQOP2 (DQOP[2], DQOP_OUT[2]);
  buf B_DQOP3 (DQOP[3], DQOP_OUT[3]);
  buf B_DQOP4 (DQOP[4], DQOP_OUT[4]);
  buf B_DQOP5 (DQOP[5], DQOP_OUT[5]);
  buf B_DQOP6 (DQOP[6], DQOP_OUT[6]);
  buf B_DQOP7 (DQOP[7], DQOP_OUT[7]);
  buf B_DQOP8 (DQOP[8], DQOP_OUT[8]);
  buf B_DQOP9 (DQOP[9], DQOP_OUT[9]);
  buf B_DQSIOWEN90N (DQSIOWEN90N, DQSIOWEN90N_OUT);
  buf B_DQSIOWEN90P (DQSIOWEN90P, DQSIOWEN90P_OUT);
  buf B_IOIDRPADD (IOIDRPADD, IOIDRPADD_OUT);
  buf B_IOIDRPADDR0 (IOIDRPADDR[0], IOIDRPADDR_OUT[0]);
  buf B_IOIDRPADDR1 (IOIDRPADDR[1], IOIDRPADDR_OUT[1]);
  buf B_IOIDRPADDR2 (IOIDRPADDR[2], IOIDRPADDR_OUT[2]);
  buf B_IOIDRPADDR3 (IOIDRPADDR[3], IOIDRPADDR_OUT[3]);
  buf B_IOIDRPADDR4 (IOIDRPADDR[4], IOIDRPADDR_OUT[4]);
  buf B_IOIDRPBROADCAST (IOIDRPBROADCAST, IOIDRPBROADCAST_OUT);
  buf B_IOIDRPCLK (IOIDRPCLK, IOIDRPCLK_OUT);
  buf B_IOIDRPCS (IOIDRPCS, IOIDRPCS_OUT);
  buf B_IOIDRPSDO (IOIDRPSDO, IOIDRPSDO_OUT);
  buf B_IOIDRPTRAIN (IOIDRPTRAIN, IOIDRPTRAIN_OUT);
  buf B_IOIDRPUPDATE (IOIDRPUPDATE, IOIDRPUPDATE_OUT);
  buf B_LDMN (LDMN, LDMN_OUT);
  buf B_LDMP (LDMP, LDMP_OUT);
  buf B_ODT (ODT, ODT_OUT);
  buf B_P0CMDEMPTY (P0CMDEMPTY, P0CMDEMPTY_OUT);
  buf B_P0CMDFULL (P0CMDFULL, P0CMDFULL_OUT);
  buf B_P0RDCOUNT0 (P0RDCOUNT[0], P0RDCOUNT_OUT[0]);
  buf B_P0RDCOUNT1 (P0RDCOUNT[1], P0RDCOUNT_OUT[1]);
  buf B_P0RDCOUNT2 (P0RDCOUNT[2], P0RDCOUNT_OUT[2]);
  buf B_P0RDCOUNT3 (P0RDCOUNT[3], P0RDCOUNT_OUT[3]);
  buf B_P0RDCOUNT4 (P0RDCOUNT[4], P0RDCOUNT_OUT[4]);
  buf B_P0RDCOUNT5 (P0RDCOUNT[5], P0RDCOUNT_OUT[5]);
  buf B_P0RDCOUNT6 (P0RDCOUNT[6], P0RDCOUNT_OUT[6]);
  buf B_P0RDDATA0 (P0RDDATA[0], P0RDDATA_OUT[0]);
  buf B_P0RDDATA1 (P0RDDATA[1], P0RDDATA_OUT[1]);
  buf B_P0RDDATA10 (P0RDDATA[10], P0RDDATA_OUT[10]);
  buf B_P0RDDATA11 (P0RDDATA[11], P0RDDATA_OUT[11]);
  buf B_P0RDDATA12 (P0RDDATA[12], P0RDDATA_OUT[12]);
  buf B_P0RDDATA13 (P0RDDATA[13], P0RDDATA_OUT[13]);
  buf B_P0RDDATA14 (P0RDDATA[14], P0RDDATA_OUT[14]);
  buf B_P0RDDATA15 (P0RDDATA[15], P0RDDATA_OUT[15]);
  buf B_P0RDDATA16 (P0RDDATA[16], P0RDDATA_OUT[16]);
  buf B_P0RDDATA17 (P0RDDATA[17], P0RDDATA_OUT[17]);
  buf B_P0RDDATA18 (P0RDDATA[18], P0RDDATA_OUT[18]);
  buf B_P0RDDATA19 (P0RDDATA[19], P0RDDATA_OUT[19]);
  buf B_P0RDDATA2 (P0RDDATA[2], P0RDDATA_OUT[2]);
  buf B_P0RDDATA20 (P0RDDATA[20], P0RDDATA_OUT[20]);
  buf B_P0RDDATA21 (P0RDDATA[21], P0RDDATA_OUT[21]);
  buf B_P0RDDATA22 (P0RDDATA[22], P0RDDATA_OUT[22]);
  buf B_P0RDDATA23 (P0RDDATA[23], P0RDDATA_OUT[23]);
  buf B_P0RDDATA24 (P0RDDATA[24], P0RDDATA_OUT[24]);
  buf B_P0RDDATA25 (P0RDDATA[25], P0RDDATA_OUT[25]);
  buf B_P0RDDATA26 (P0RDDATA[26], P0RDDATA_OUT[26]);
  buf B_P0RDDATA27 (P0RDDATA[27], P0RDDATA_OUT[27]);
  buf B_P0RDDATA28 (P0RDDATA[28], P0RDDATA_OUT[28]);
  buf B_P0RDDATA29 (P0RDDATA[29], P0RDDATA_OUT[29]);
  buf B_P0RDDATA3 (P0RDDATA[3], P0RDDATA_OUT[3]);
  buf B_P0RDDATA30 (P0RDDATA[30], P0RDDATA_OUT[30]);
  buf B_P0RDDATA31 (P0RDDATA[31], P0RDDATA_OUT[31]);
  buf B_P0RDDATA4 (P0RDDATA[4], P0RDDATA_OUT[4]);
  buf B_P0RDDATA5 (P0RDDATA[5], P0RDDATA_OUT[5]);
  buf B_P0RDDATA6 (P0RDDATA[6], P0RDDATA_OUT[6]);
  buf B_P0RDDATA7 (P0RDDATA[7], P0RDDATA_OUT[7]);
  buf B_P0RDDATA8 (P0RDDATA[8], P0RDDATA_OUT[8]);
  buf B_P0RDDATA9 (P0RDDATA[9], P0RDDATA_OUT[9]);
  buf B_P0RDEMPTY (P0RDEMPTY, P0RDEMPTY_OUT);
  buf B_P0RDERROR (P0RDERROR, P0RDERROR_OUT);
  buf B_P0RDFULL (P0RDFULL, P0RDFULL_OUT);
  buf B_P0RDOVERFLOW (P0RDOVERFLOW, P0RDOVERFLOW_OUT);
  buf B_P0WRCOUNT0 (P0WRCOUNT[0], P0WRCOUNT_OUT[0]);
  buf B_P0WRCOUNT1 (P0WRCOUNT[1], P0WRCOUNT_OUT[1]);
  buf B_P0WRCOUNT2 (P0WRCOUNT[2], P0WRCOUNT_OUT[2]);
  buf B_P0WRCOUNT3 (P0WRCOUNT[3], P0WRCOUNT_OUT[3]);
  buf B_P0WRCOUNT4 (P0WRCOUNT[4], P0WRCOUNT_OUT[4]);
  buf B_P0WRCOUNT5 (P0WRCOUNT[5], P0WRCOUNT_OUT[5]);
  buf B_P0WRCOUNT6 (P0WRCOUNT[6], P0WRCOUNT_OUT[6]);
  buf B_P0WREMPTY (P0WREMPTY, P0WREMPTY_OUT);
  buf B_P0WRERROR (P0WRERROR, P0WRERROR_OUT);
  buf B_P0WRFULL (P0WRFULL, P0WRFULL_OUT);
  buf B_P0WRUNDERRUN (P0WRUNDERRUN, P0WRUNDERRUN_OUT);
  buf B_P1CMDEMPTY (P1CMDEMPTY, P1CMDEMPTY_OUT);
  buf B_P1CMDFULL (P1CMDFULL, P1CMDFULL_OUT);
  buf B_P1RDCOUNT0 (P1RDCOUNT[0], P1RDCOUNT_OUT[0]);
  buf B_P1RDCOUNT1 (P1RDCOUNT[1], P1RDCOUNT_OUT[1]);
  buf B_P1RDCOUNT2 (P1RDCOUNT[2], P1RDCOUNT_OUT[2]);
  buf B_P1RDCOUNT3 (P1RDCOUNT[3], P1RDCOUNT_OUT[3]);
  buf B_P1RDCOUNT4 (P1RDCOUNT[4], P1RDCOUNT_OUT[4]);
  buf B_P1RDCOUNT5 (P1RDCOUNT[5], P1RDCOUNT_OUT[5]);
  buf B_P1RDCOUNT6 (P1RDCOUNT[6], P1RDCOUNT_OUT[6]);
  buf B_P1RDDATA0 (P1RDDATA[0], P1RDDATA_OUT[0]);
  buf B_P1RDDATA1 (P1RDDATA[1], P1RDDATA_OUT[1]);
  buf B_P1RDDATA10 (P1RDDATA[10], P1RDDATA_OUT[10]);
  buf B_P1RDDATA11 (P1RDDATA[11], P1RDDATA_OUT[11]);
  buf B_P1RDDATA12 (P1RDDATA[12], P1RDDATA_OUT[12]);
  buf B_P1RDDATA13 (P1RDDATA[13], P1RDDATA_OUT[13]);
  buf B_P1RDDATA14 (P1RDDATA[14], P1RDDATA_OUT[14]);
  buf B_P1RDDATA15 (P1RDDATA[15], P1RDDATA_OUT[15]);
  buf B_P1RDDATA16 (P1RDDATA[16], P1RDDATA_OUT[16]);
  buf B_P1RDDATA17 (P1RDDATA[17], P1RDDATA_OUT[17]);
  buf B_P1RDDATA18 (P1RDDATA[18], P1RDDATA_OUT[18]);
  buf B_P1RDDATA19 (P1RDDATA[19], P1RDDATA_OUT[19]);
  buf B_P1RDDATA2 (P1RDDATA[2], P1RDDATA_OUT[2]);
  buf B_P1RDDATA20 (P1RDDATA[20], P1RDDATA_OUT[20]);
  buf B_P1RDDATA21 (P1RDDATA[21], P1RDDATA_OUT[21]);
  buf B_P1RDDATA22 (P1RDDATA[22], P1RDDATA_OUT[22]);
  buf B_P1RDDATA23 (P1RDDATA[23], P1RDDATA_OUT[23]);
  buf B_P1RDDATA24 (P1RDDATA[24], P1RDDATA_OUT[24]);
  buf B_P1RDDATA25 (P1RDDATA[25], P1RDDATA_OUT[25]);
  buf B_P1RDDATA26 (P1RDDATA[26], P1RDDATA_OUT[26]);
  buf B_P1RDDATA27 (P1RDDATA[27], P1RDDATA_OUT[27]);
  buf B_P1RDDATA28 (P1RDDATA[28], P1RDDATA_OUT[28]);
  buf B_P1RDDATA29 (P1RDDATA[29], P1RDDATA_OUT[29]);
  buf B_P1RDDATA3 (P1RDDATA[3], P1RDDATA_OUT[3]);
  buf B_P1RDDATA30 (P1RDDATA[30], P1RDDATA_OUT[30]);
  buf B_P1RDDATA31 (P1RDDATA[31], P1RDDATA_OUT[31]);
  buf B_P1RDDATA4 (P1RDDATA[4], P1RDDATA_OUT[4]);
  buf B_P1RDDATA5 (P1RDDATA[5], P1RDDATA_OUT[5]);
  buf B_P1RDDATA6 (P1RDDATA[6], P1RDDATA_OUT[6]);
  buf B_P1RDDATA7 (P1RDDATA[7], P1RDDATA_OUT[7]);
  buf B_P1RDDATA8 (P1RDDATA[8], P1RDDATA_OUT[8]);
  buf B_P1RDDATA9 (P1RDDATA[9], P1RDDATA_OUT[9]);
  buf B_P1RDEMPTY (P1RDEMPTY, P1RDEMPTY_OUT);
  buf B_P1RDERROR (P1RDERROR, P1RDERROR_OUT);
  buf B_P1RDFULL (P1RDFULL, P1RDFULL_OUT);
  buf B_P1RDOVERFLOW (P1RDOVERFLOW, P1RDOVERFLOW_OUT);
  buf B_P1WRCOUNT0 (P1WRCOUNT[0], P1WRCOUNT_OUT[0]);
  buf B_P1WRCOUNT1 (P1WRCOUNT[1], P1WRCOUNT_OUT[1]);
  buf B_P1WRCOUNT2 (P1WRCOUNT[2], P1WRCOUNT_OUT[2]);
  buf B_P1WRCOUNT3 (P1WRCOUNT[3], P1WRCOUNT_OUT[3]);
  buf B_P1WRCOUNT4 (P1WRCOUNT[4], P1WRCOUNT_OUT[4]);
  buf B_P1WRCOUNT5 (P1WRCOUNT[5], P1WRCOUNT_OUT[5]);
  buf B_P1WRCOUNT6 (P1WRCOUNT[6], P1WRCOUNT_OUT[6]);
  buf B_P1WREMPTY (P1WREMPTY, P1WREMPTY_OUT);
  buf B_P1WRERROR (P1WRERROR, P1WRERROR_OUT);
  buf B_P1WRFULL (P1WRFULL, P1WRFULL_OUT);
  buf B_P1WRUNDERRUN (P1WRUNDERRUN, P1WRUNDERRUN_OUT);
  buf B_P2CMDEMPTY (P2CMDEMPTY, P2CMDEMPTY_OUT);
  buf B_P2CMDFULL (P2CMDFULL, P2CMDFULL_OUT);
  buf B_P2COUNT0 (P2COUNT[0], P2COUNT_OUT[0]);
  buf B_P2COUNT1 (P2COUNT[1], P2COUNT_OUT[1]);
  buf B_P2COUNT2 (P2COUNT[2], P2COUNT_OUT[2]);
  buf B_P2COUNT3 (P2COUNT[3], P2COUNT_OUT[3]);
  buf B_P2COUNT4 (P2COUNT[4], P2COUNT_OUT[4]);
  buf B_P2COUNT5 (P2COUNT[5], P2COUNT_OUT[5]);
  buf B_P2COUNT6 (P2COUNT[6], P2COUNT_OUT[6]);
  buf B_P2EMPTY (P2EMPTY, P2EMPTY_OUT);
  buf B_P2ERROR (P2ERROR, P2ERROR_OUT);
  buf B_P2FULL (P2FULL, P2FULL_OUT);
  buf B_P2RDDATA0 (P2RDDATA[0], P2RDDATA_OUT[0]);
  buf B_P2RDDATA1 (P2RDDATA[1], P2RDDATA_OUT[1]);
  buf B_P2RDDATA10 (P2RDDATA[10], P2RDDATA_OUT[10]);
  buf B_P2RDDATA11 (P2RDDATA[11], P2RDDATA_OUT[11]);
  buf B_P2RDDATA12 (P2RDDATA[12], P2RDDATA_OUT[12]);
  buf B_P2RDDATA13 (P2RDDATA[13], P2RDDATA_OUT[13]);
  buf B_P2RDDATA14 (P2RDDATA[14], P2RDDATA_OUT[14]);
  buf B_P2RDDATA15 (P2RDDATA[15], P2RDDATA_OUT[15]);
  buf B_P2RDDATA16 (P2RDDATA[16], P2RDDATA_OUT[16]);
  buf B_P2RDDATA17 (P2RDDATA[17], P2RDDATA_OUT[17]);
  buf B_P2RDDATA18 (P2RDDATA[18], P2RDDATA_OUT[18]);
  buf B_P2RDDATA19 (P2RDDATA[19], P2RDDATA_OUT[19]);
  buf B_P2RDDATA2 (P2RDDATA[2], P2RDDATA_OUT[2]);
  buf B_P2RDDATA20 (P2RDDATA[20], P2RDDATA_OUT[20]);
  buf B_P2RDDATA21 (P2RDDATA[21], P2RDDATA_OUT[21]);
  buf B_P2RDDATA22 (P2RDDATA[22], P2RDDATA_OUT[22]);
  buf B_P2RDDATA23 (P2RDDATA[23], P2RDDATA_OUT[23]);
  buf B_P2RDDATA24 (P2RDDATA[24], P2RDDATA_OUT[24]);
  buf B_P2RDDATA25 (P2RDDATA[25], P2RDDATA_OUT[25]);
  buf B_P2RDDATA26 (P2RDDATA[26], P2RDDATA_OUT[26]);
  buf B_P2RDDATA27 (P2RDDATA[27], P2RDDATA_OUT[27]);
  buf B_P2RDDATA28 (P2RDDATA[28], P2RDDATA_OUT[28]);
  buf B_P2RDDATA29 (P2RDDATA[29], P2RDDATA_OUT[29]);
  buf B_P2RDDATA3 (P2RDDATA[3], P2RDDATA_OUT[3]);
  buf B_P2RDDATA30 (P2RDDATA[30], P2RDDATA_OUT[30]);
  buf B_P2RDDATA31 (P2RDDATA[31], P2RDDATA_OUT[31]);
  buf B_P2RDDATA4 (P2RDDATA[4], P2RDDATA_OUT[4]);
  buf B_P2RDDATA5 (P2RDDATA[5], P2RDDATA_OUT[5]);
  buf B_P2RDDATA6 (P2RDDATA[6], P2RDDATA_OUT[6]);
  buf B_P2RDDATA7 (P2RDDATA[7], P2RDDATA_OUT[7]);
  buf B_P2RDDATA8 (P2RDDATA[8], P2RDDATA_OUT[8]);
  buf B_P2RDDATA9 (P2RDDATA[9], P2RDDATA_OUT[9]);
  buf B_P2RDOVERFLOW (P2RDOVERFLOW, P2RDOVERFLOW_OUT);
  buf B_P2WRUNDERRUN (P2WRUNDERRUN, P2WRUNDERRUN_OUT);
  buf B_P3CMDEMPTY (P3CMDEMPTY, P3CMDEMPTY_OUT);
  buf B_P3CMDFULL (P3CMDFULL, P3CMDFULL_OUT);
  buf B_P3COUNT0 (P3COUNT[0], P3COUNT_OUT[0]);
  buf B_P3COUNT1 (P3COUNT[1], P3COUNT_OUT[1]);
  buf B_P3COUNT2 (P3COUNT[2], P3COUNT_OUT[2]);
  buf B_P3COUNT3 (P3COUNT[3], P3COUNT_OUT[3]);
  buf B_P3COUNT4 (P3COUNT[4], P3COUNT_OUT[4]);
  buf B_P3COUNT5 (P3COUNT[5], P3COUNT_OUT[5]);
  buf B_P3COUNT6 (P3COUNT[6], P3COUNT_OUT[6]);
  buf B_P3EMPTY (P3EMPTY, P3EMPTY_OUT);
  buf B_P3ERROR (P3ERROR, P3ERROR_OUT);
  buf B_P3FULL (P3FULL, P3FULL_OUT);
  buf B_P3RDDATA0 (P3RDDATA[0], P3RDDATA_OUT[0]);
  buf B_P3RDDATA1 (P3RDDATA[1], P3RDDATA_OUT[1]);
  buf B_P3RDDATA10 (P3RDDATA[10], P3RDDATA_OUT[10]);
  buf B_P3RDDATA11 (P3RDDATA[11], P3RDDATA_OUT[11]);
  buf B_P3RDDATA12 (P3RDDATA[12], P3RDDATA_OUT[12]);
  buf B_P3RDDATA13 (P3RDDATA[13], P3RDDATA_OUT[13]);
  buf B_P3RDDATA14 (P3RDDATA[14], P3RDDATA_OUT[14]);
  buf B_P3RDDATA15 (P3RDDATA[15], P3RDDATA_OUT[15]);
  buf B_P3RDDATA16 (P3RDDATA[16], P3RDDATA_OUT[16]);
  buf B_P3RDDATA17 (P3RDDATA[17], P3RDDATA_OUT[17]);
  buf B_P3RDDATA18 (P3RDDATA[18], P3RDDATA_OUT[18]);
  buf B_P3RDDATA19 (P3RDDATA[19], P3RDDATA_OUT[19]);
  buf B_P3RDDATA2 (P3RDDATA[2], P3RDDATA_OUT[2]);
  buf B_P3RDDATA20 (P3RDDATA[20], P3RDDATA_OUT[20]);
  buf B_P3RDDATA21 (P3RDDATA[21], P3RDDATA_OUT[21]);
  buf B_P3RDDATA22 (P3RDDATA[22], P3RDDATA_OUT[22]);
  buf B_P3RDDATA23 (P3RDDATA[23], P3RDDATA_OUT[23]);
  buf B_P3RDDATA24 (P3RDDATA[24], P3RDDATA_OUT[24]);
  buf B_P3RDDATA25 (P3RDDATA[25], P3RDDATA_OUT[25]);
  buf B_P3RDDATA26 (P3RDDATA[26], P3RDDATA_OUT[26]);
  buf B_P3RDDATA27 (P3RDDATA[27], P3RDDATA_OUT[27]);
  buf B_P3RDDATA28 (P3RDDATA[28], P3RDDATA_OUT[28]);
  buf B_P3RDDATA29 (P3RDDATA[29], P3RDDATA_OUT[29]);
  buf B_P3RDDATA3 (P3RDDATA[3], P3RDDATA_OUT[3]);
  buf B_P3RDDATA30 (P3RDDATA[30], P3RDDATA_OUT[30]);
  buf B_P3RDDATA31 (P3RDDATA[31], P3RDDATA_OUT[31]);
  buf B_P3RDDATA4 (P3RDDATA[4], P3RDDATA_OUT[4]);
  buf B_P3RDDATA5 (P3RDDATA[5], P3RDDATA_OUT[5]);
  buf B_P3RDDATA6 (P3RDDATA[6], P3RDDATA_OUT[6]);
  buf B_P3RDDATA7 (P3RDDATA[7], P3RDDATA_OUT[7]);
  buf B_P3RDDATA8 (P3RDDATA[8], P3RDDATA_OUT[8]);
  buf B_P3RDDATA9 (P3RDDATA[9], P3RDDATA_OUT[9]);
  buf B_P3RDOVERFLOW (P3RDOVERFLOW, P3RDOVERFLOW_OUT);
  buf B_P3WRUNDERRUN (P3WRUNDERRUN, P3WRUNDERRUN_OUT);
  buf B_P4CMDEMPTY (P4CMDEMPTY, P4CMDEMPTY_OUT);
  buf B_P4CMDFULL (P4CMDFULL, P4CMDFULL_OUT);
  buf B_P4COUNT0 (P4COUNT[0], P4COUNT_OUT[0]);
  buf B_P4COUNT1 (P4COUNT[1], P4COUNT_OUT[1]);
  buf B_P4COUNT2 (P4COUNT[2], P4COUNT_OUT[2]);
  buf B_P4COUNT3 (P4COUNT[3], P4COUNT_OUT[3]);
  buf B_P4COUNT4 (P4COUNT[4], P4COUNT_OUT[4]);
  buf B_P4COUNT5 (P4COUNT[5], P4COUNT_OUT[5]);
  buf B_P4COUNT6 (P4COUNT[6], P4COUNT_OUT[6]);
  buf B_P4EMPTY (P4EMPTY, P4EMPTY_OUT);
  buf B_P4ERROR (P4ERROR, P4ERROR_OUT);
  buf B_P4FULL (P4FULL, P4FULL_OUT);
  buf B_P4RDDATA0 (P4RDDATA[0], P4RDDATA_OUT[0]);
  buf B_P4RDDATA1 (P4RDDATA[1], P4RDDATA_OUT[1]);
  buf B_P4RDDATA10 (P4RDDATA[10], P4RDDATA_OUT[10]);
  buf B_P4RDDATA11 (P4RDDATA[11], P4RDDATA_OUT[11]);
  buf B_P4RDDATA12 (P4RDDATA[12], P4RDDATA_OUT[12]);
  buf B_P4RDDATA13 (P4RDDATA[13], P4RDDATA_OUT[13]);
  buf B_P4RDDATA14 (P4RDDATA[14], P4RDDATA_OUT[14]);
  buf B_P4RDDATA15 (P4RDDATA[15], P4RDDATA_OUT[15]);
  buf B_P4RDDATA16 (P4RDDATA[16], P4RDDATA_OUT[16]);
  buf B_P4RDDATA17 (P4RDDATA[17], P4RDDATA_OUT[17]);
  buf B_P4RDDATA18 (P4RDDATA[18], P4RDDATA_OUT[18]);
  buf B_P4RDDATA19 (P4RDDATA[19], P4RDDATA_OUT[19]);
  buf B_P4RDDATA2 (P4RDDATA[2], P4RDDATA_OUT[2]);
  buf B_P4RDDATA20 (P4RDDATA[20], P4RDDATA_OUT[20]);
  buf B_P4RDDATA21 (P4RDDATA[21], P4RDDATA_OUT[21]);
  buf B_P4RDDATA22 (P4RDDATA[22], P4RDDATA_OUT[22]);
  buf B_P4RDDATA23 (P4RDDATA[23], P4RDDATA_OUT[23]);
  buf B_P4RDDATA24 (P4RDDATA[24], P4RDDATA_OUT[24]);
  buf B_P4RDDATA25 (P4RDDATA[25], P4RDDATA_OUT[25]);
  buf B_P4RDDATA26 (P4RDDATA[26], P4RDDATA_OUT[26]);
  buf B_P4RDDATA27 (P4RDDATA[27], P4RDDATA_OUT[27]);
  buf B_P4RDDATA28 (P4RDDATA[28], P4RDDATA_OUT[28]);
  buf B_P4RDDATA29 (P4RDDATA[29], P4RDDATA_OUT[29]);
  buf B_P4RDDATA3 (P4RDDATA[3], P4RDDATA_OUT[3]);
  buf B_P4RDDATA30 (P4RDDATA[30], P4RDDATA_OUT[30]);
  buf B_P4RDDATA31 (P4RDDATA[31], P4RDDATA_OUT[31]);
  buf B_P4RDDATA4 (P4RDDATA[4], P4RDDATA_OUT[4]);
  buf B_P4RDDATA5 (P4RDDATA[5], P4RDDATA_OUT[5]);
  buf B_P4RDDATA6 (P4RDDATA[6], P4RDDATA_OUT[6]);
  buf B_P4RDDATA7 (P4RDDATA[7], P4RDDATA_OUT[7]);
  buf B_P4RDDATA8 (P4RDDATA[8], P4RDDATA_OUT[8]);
  buf B_P4RDDATA9 (P4RDDATA[9], P4RDDATA_OUT[9]);
  buf B_P4RDOVERFLOW (P4RDOVERFLOW, P4RDOVERFLOW_OUT);
  buf B_P4WRUNDERRUN (P4WRUNDERRUN, P4WRUNDERRUN_OUT);
  buf B_P5CMDEMPTY (P5CMDEMPTY, P5CMDEMPTY_OUT);
  buf B_P5CMDFULL (P5CMDFULL, P5CMDFULL_OUT);
  buf B_P5COUNT0 (P5COUNT[0], P5COUNT_OUT[0]);
  buf B_P5COUNT1 (P5COUNT[1], P5COUNT_OUT[1]);
  buf B_P5COUNT2 (P5COUNT[2], P5COUNT_OUT[2]);
  buf B_P5COUNT3 (P5COUNT[3], P5COUNT_OUT[3]);
  buf B_P5COUNT4 (P5COUNT[4], P5COUNT_OUT[4]);
  buf B_P5COUNT5 (P5COUNT[5], P5COUNT_OUT[5]);
  buf B_P5COUNT6 (P5COUNT[6], P5COUNT_OUT[6]);
  buf B_P5EMPTY (P5EMPTY, P5EMPTY_OUT);
  buf B_P5ERROR (P5ERROR, P5ERROR_OUT);
  buf B_P5FULL (P5FULL, P5FULL_OUT);
  buf B_P5RDDATA0 (P5RDDATA[0], P5RDDATA_OUT[0]);
  buf B_P5RDDATA1 (P5RDDATA[1], P5RDDATA_OUT[1]);
  buf B_P5RDDATA10 (P5RDDATA[10], P5RDDATA_OUT[10]);
  buf B_P5RDDATA11 (P5RDDATA[11], P5RDDATA_OUT[11]);
  buf B_P5RDDATA12 (P5RDDATA[12], P5RDDATA_OUT[12]);
  buf B_P5RDDATA13 (P5RDDATA[13], P5RDDATA_OUT[13]);
  buf B_P5RDDATA14 (P5RDDATA[14], P5RDDATA_OUT[14]);
  buf B_P5RDDATA15 (P5RDDATA[15], P5RDDATA_OUT[15]);
  buf B_P5RDDATA16 (P5RDDATA[16], P5RDDATA_OUT[16]);
  buf B_P5RDDATA17 (P5RDDATA[17], P5RDDATA_OUT[17]);
  buf B_P5RDDATA18 (P5RDDATA[18], P5RDDATA_OUT[18]);
  buf B_P5RDDATA19 (P5RDDATA[19], P5RDDATA_OUT[19]);
  buf B_P5RDDATA2 (P5RDDATA[2], P5RDDATA_OUT[2]);
  buf B_P5RDDATA20 (P5RDDATA[20], P5RDDATA_OUT[20]);
  buf B_P5RDDATA21 (P5RDDATA[21], P5RDDATA_OUT[21]);
  buf B_P5RDDATA22 (P5RDDATA[22], P5RDDATA_OUT[22]);
  buf B_P5RDDATA23 (P5RDDATA[23], P5RDDATA_OUT[23]);
  buf B_P5RDDATA24 (P5RDDATA[24], P5RDDATA_OUT[24]);
  buf B_P5RDDATA25 (P5RDDATA[25], P5RDDATA_OUT[25]);
  buf B_P5RDDATA26 (P5RDDATA[26], P5RDDATA_OUT[26]);
  buf B_P5RDDATA27 (P5RDDATA[27], P5RDDATA_OUT[27]);
  buf B_P5RDDATA28 (P5RDDATA[28], P5RDDATA_OUT[28]);
  buf B_P5RDDATA29 (P5RDDATA[29], P5RDDATA_OUT[29]);
  buf B_P5RDDATA3 (P5RDDATA[3], P5RDDATA_OUT[3]);
  buf B_P5RDDATA30 (P5RDDATA[30], P5RDDATA_OUT[30]);
  buf B_P5RDDATA31 (P5RDDATA[31], P5RDDATA_OUT[31]);
  buf B_P5RDDATA4 (P5RDDATA[4], P5RDDATA_OUT[4]);
  buf B_P5RDDATA5 (P5RDDATA[5], P5RDDATA_OUT[5]);
  buf B_P5RDDATA6 (P5RDDATA[6], P5RDDATA_OUT[6]);
  buf B_P5RDDATA7 (P5RDDATA[7], P5RDDATA_OUT[7]);
  buf B_P5RDDATA8 (P5RDDATA[8], P5RDDATA_OUT[8]);
  buf B_P5RDDATA9 (P5RDDATA[9], P5RDDATA_OUT[9]);
  buf B_P5RDOVERFLOW (P5RDOVERFLOW, P5RDOVERFLOW_OUT);
  buf B_P5WRUNDERRUN (P5WRUNDERRUN, P5WRUNDERRUN_OUT);
  buf B_RAS (RAS, RAS_OUT);
  buf B_RST (RST, RST_OUT);
  buf B_SELFREFRESHMODE (SELFREFRESHMODE, SELFREFRESHMODE_OUT);
  buf B_STATUS0 (STATUS[0], STATUS_OUT[0]);
  buf B_STATUS1 (STATUS[1], STATUS_OUT[1]);
  buf B_STATUS10 (STATUS[10], STATUS_OUT[10]);
  buf B_STATUS11 (STATUS[11], STATUS_OUT[11]);
  buf B_STATUS12 (STATUS[12], STATUS_OUT[12]);
  buf B_STATUS13 (STATUS[13], STATUS_OUT[13]);
  buf B_STATUS14 (STATUS[14], STATUS_OUT[14]);
  buf B_STATUS15 (STATUS[15], STATUS_OUT[15]);
  buf B_STATUS16 (STATUS[16], STATUS_OUT[16]);
  buf B_STATUS17 (STATUS[17], STATUS_OUT[17]);
  buf B_STATUS18 (STATUS[18], STATUS_OUT[18]);
  buf B_STATUS19 (STATUS[19], STATUS_OUT[19]);
  buf B_STATUS2 (STATUS[2], STATUS_OUT[2]);
  buf B_STATUS20 (STATUS[20], STATUS_OUT[20]);
  buf B_STATUS21 (STATUS[21], STATUS_OUT[21]);
  buf B_STATUS22 (STATUS[22], STATUS_OUT[22]);
  buf B_STATUS23 (STATUS[23], STATUS_OUT[23]);
  buf B_STATUS24 (STATUS[24], STATUS_OUT[24]);
  buf B_STATUS25 (STATUS[25], STATUS_OUT[25]);
  buf B_STATUS26 (STATUS[26], STATUS_OUT[26]);
  buf B_STATUS27 (STATUS[27], STATUS_OUT[27]);
  buf B_STATUS28 (STATUS[28], STATUS_OUT[28]);
  buf B_STATUS29 (STATUS[29], STATUS_OUT[29]);
  buf B_STATUS3 (STATUS[3], STATUS_OUT[3]);
  buf B_STATUS30 (STATUS[30], STATUS_OUT[30]);
  buf B_STATUS31 (STATUS[31], STATUS_OUT[31]);
  buf B_STATUS4 (STATUS[4], STATUS_OUT[4]);
  buf B_STATUS5 (STATUS[5], STATUS_OUT[5]);
  buf B_STATUS6 (STATUS[6], STATUS_OUT[6]);
  buf B_STATUS7 (STATUS[7], STATUS_OUT[7]);
  buf B_STATUS8 (STATUS[8], STATUS_OUT[8]);
  buf B_STATUS9 (STATUS[9], STATUS_OUT[9]);
  buf B_UDMN (UDMN, UDMN_OUT);
  buf B_UDMP (UDMP, UDMP_OUT);
  buf B_UOCALSTART (UOCALSTART, UOCALSTART_OUT);
  buf B_UOCMDREADYIN (UOCMDREADYIN, UOCMDREADYIN_OUT);
  buf B_UODATA0 (UODATA[0], UODATA_OUT[0]);
  buf B_UODATA1 (UODATA[1], UODATA_OUT[1]);
  buf B_UODATA2 (UODATA[2], UODATA_OUT[2]);
  buf B_UODATA3 (UODATA[3], UODATA_OUT[3]);
  buf B_UODATA4 (UODATA[4], UODATA_OUT[4]);
  buf B_UODATA5 (UODATA[5], UODATA_OUT[5]);
  buf B_UODATA6 (UODATA[6], UODATA_OUT[6]);
  buf B_UODATA7 (UODATA[7], UODATA_OUT[7]);
  buf B_UODATAVALID (UODATAVALID, UODATAVALID_OUT);
  buf B_UODONECAL (UODONECAL, UODONECAL_OUT);
  buf B_UOREFRSHFLAG (UOREFRSHFLAG, UOREFRSHFLAG_OUT);
  buf B_UOSDO (UOSDO, UOSDO_OUT);
  buf B_WE (WE, WE_OUT);

  buf B_DQI0 (DQI_IN[0], DQI[0]);
  buf B_DQI1 (DQI_IN[1], DQI[1]);
  buf B_DQI10 (DQI_IN[10], DQI[10]);
  buf B_DQI11 (DQI_IN[11], DQI[11]);
  buf B_DQI12 (DQI_IN[12], DQI[12]);
  buf B_DQI13 (DQI_IN[13], DQI[13]);
  buf B_DQI14 (DQI_IN[14], DQI[14]);
  buf B_DQI15 (DQI_IN[15], DQI[15]);
  buf B_DQI2 (DQI_IN[2], DQI[2]);
  buf B_DQI3 (DQI_IN[3], DQI[3]);
  buf B_DQI4 (DQI_IN[4], DQI[4]);
  buf B_DQI5 (DQI_IN[5], DQI[5]);
  buf B_DQI6 (DQI_IN[6], DQI[6]);
  buf B_DQI7 (DQI_IN[7], DQI[7]);
  buf B_DQI8 (DQI_IN[8], DQI[8]);
  buf B_DQI9 (DQI_IN[9], DQI[9]);
  buf B_DQSIOIN (DQSIOIN_IN, DQSIOIN);
  buf B_DQSIOIP (DQSIOIP_IN, DQSIOIP);
  buf B_IOIDRPSDI (IOIDRPSDI_IN, IOIDRPSDI);
  buf B_P0ARBEN (P0ARBEN_IN, P0ARBEN);
  buf B_P0CMDBA0 (P0CMDBA_IN[0], P0CMDBA[0]);
  buf B_P0CMDBA1 (P0CMDBA_IN[1], P0CMDBA[1]);
  buf B_P0CMDBA2 (P0CMDBA_IN[2], P0CMDBA[2]);
  buf B_P0CMDBL0 (P0CMDBL_IN[0], P0CMDBL[0]);
  buf B_P0CMDBL1 (P0CMDBL_IN[1], P0CMDBL[1]);
  buf B_P0CMDBL2 (P0CMDBL_IN[2], P0CMDBL[2]);
  buf B_P0CMDBL3 (P0CMDBL_IN[3], P0CMDBL[3]);
  buf B_P0CMDBL4 (P0CMDBL_IN[4], P0CMDBL[4]);
  buf B_P0CMDBL5 (P0CMDBL_IN[5], P0CMDBL[5]);
  buf B_P0CMDCA0 (P0CMDCA_IN[0], P0CMDCA[0]);
  buf B_P0CMDCA1 (P0CMDCA_IN[1], P0CMDCA[1]);
  buf B_P0CMDCA10 (P0CMDCA_IN[10], P0CMDCA[10]);
  buf B_P0CMDCA11 (P0CMDCA_IN[11], P0CMDCA[11]);
  buf B_P0CMDCA2 (P0CMDCA_IN[2], P0CMDCA[2]);
  buf B_P0CMDCA3 (P0CMDCA_IN[3], P0CMDCA[3]);
  buf B_P0CMDCA4 (P0CMDCA_IN[4], P0CMDCA[4]);
  buf B_P0CMDCA5 (P0CMDCA_IN[5], P0CMDCA[5]);
  buf B_P0CMDCA6 (P0CMDCA_IN[6], P0CMDCA[6]);
  buf B_P0CMDCA7 (P0CMDCA_IN[7], P0CMDCA[7]);
  buf B_P0CMDCA8 (P0CMDCA_IN[8], P0CMDCA[8]);
  buf B_P0CMDCA9 (P0CMDCA_IN[9], P0CMDCA[9]);
  buf B_P0CMDCLK (P0CMDCLK_IN, P0CMDCLK);
  buf B_P0CMDEN (P0CMDEN_IN, P0CMDEN);
  buf B_P0CMDINSTR0 (P0CMDINSTR_IN[0], P0CMDINSTR[0]);
  buf B_P0CMDINSTR1 (P0CMDINSTR_IN[1], P0CMDINSTR[1]);
  buf B_P0CMDINSTR2 (P0CMDINSTR_IN[2], P0CMDINSTR[2]);
  buf B_P0CMDRA0 (P0CMDRA_IN[0], P0CMDRA[0]);
  buf B_P0CMDRA1 (P0CMDRA_IN[1], P0CMDRA[1]);
  buf B_P0CMDRA10 (P0CMDRA_IN[10], P0CMDRA[10]);
  buf B_P0CMDRA11 (P0CMDRA_IN[11], P0CMDRA[11]);
  buf B_P0CMDRA12 (P0CMDRA_IN[12], P0CMDRA[12]);
  buf B_P0CMDRA13 (P0CMDRA_IN[13], P0CMDRA[13]);
  buf B_P0CMDRA14 (P0CMDRA_IN[14], P0CMDRA[14]);
  buf B_P0CMDRA2 (P0CMDRA_IN[2], P0CMDRA[2]);
  buf B_P0CMDRA3 (P0CMDRA_IN[3], P0CMDRA[3]);
  buf B_P0CMDRA4 (P0CMDRA_IN[4], P0CMDRA[4]);
  buf B_P0CMDRA5 (P0CMDRA_IN[5], P0CMDRA[5]);
  buf B_P0CMDRA6 (P0CMDRA_IN[6], P0CMDRA[6]);
  buf B_P0CMDRA7 (P0CMDRA_IN[7], P0CMDRA[7]);
  buf B_P0CMDRA8 (P0CMDRA_IN[8], P0CMDRA[8]);
  buf B_P0CMDRA9 (P0CMDRA_IN[9], P0CMDRA[9]);
  buf B_P0RDCLK (P0RDCLK_IN, P0RDCLK);
  buf B_P0RDEN (P0RDEN_IN, P0RDEN);
  buf B_P0RWRMASK0 (P0RWRMASK_IN[0], P0RWRMASK[0]);
  buf B_P0RWRMASK1 (P0RWRMASK_IN[1], P0RWRMASK[1]);
  buf B_P0RWRMASK2 (P0RWRMASK_IN[2], P0RWRMASK[2]);
  buf B_P0RWRMASK3 (P0RWRMASK_IN[3], P0RWRMASK[3]);
  buf B_P0WRCLK (P0WRCLK_IN, P0WRCLK);
  buf B_P0WRDATA0 (P0WRDATA_IN[0], P0WRDATA[0]);
  buf B_P0WRDATA1 (P0WRDATA_IN[1], P0WRDATA[1]);
  buf B_P0WRDATA10 (P0WRDATA_IN[10], P0WRDATA[10]);
  buf B_P0WRDATA11 (P0WRDATA_IN[11], P0WRDATA[11]);
  buf B_P0WRDATA12 (P0WRDATA_IN[12], P0WRDATA[12]);
  buf B_P0WRDATA13 (P0WRDATA_IN[13], P0WRDATA[13]);
  buf B_P0WRDATA14 (P0WRDATA_IN[14], P0WRDATA[14]);
  buf B_P0WRDATA15 (P0WRDATA_IN[15], P0WRDATA[15]);
  buf B_P0WRDATA16 (P0WRDATA_IN[16], P0WRDATA[16]);
  buf B_P0WRDATA17 (P0WRDATA_IN[17], P0WRDATA[17]);
  buf B_P0WRDATA18 (P0WRDATA_IN[18], P0WRDATA[18]);
  buf B_P0WRDATA19 (P0WRDATA_IN[19], P0WRDATA[19]);
  buf B_P0WRDATA2 (P0WRDATA_IN[2], P0WRDATA[2]);
  buf B_P0WRDATA20 (P0WRDATA_IN[20], P0WRDATA[20]);
  buf B_P0WRDATA21 (P0WRDATA_IN[21], P0WRDATA[21]);
  buf B_P0WRDATA22 (P0WRDATA_IN[22], P0WRDATA[22]);
  buf B_P0WRDATA23 (P0WRDATA_IN[23], P0WRDATA[23]);
  buf B_P0WRDATA24 (P0WRDATA_IN[24], P0WRDATA[24]);
  buf B_P0WRDATA25 (P0WRDATA_IN[25], P0WRDATA[25]);
  buf B_P0WRDATA26 (P0WRDATA_IN[26], P0WRDATA[26]);
  buf B_P0WRDATA27 (P0WRDATA_IN[27], P0WRDATA[27]);
  buf B_P0WRDATA28 (P0WRDATA_IN[28], P0WRDATA[28]);
  buf B_P0WRDATA29 (P0WRDATA_IN[29], P0WRDATA[29]);
  buf B_P0WRDATA3 (P0WRDATA_IN[3], P0WRDATA[3]);
  buf B_P0WRDATA30 (P0WRDATA_IN[30], P0WRDATA[30]);
  buf B_P0WRDATA31 (P0WRDATA_IN[31], P0WRDATA[31]);
  buf B_P0WRDATA4 (P0WRDATA_IN[4], P0WRDATA[4]);
  buf B_P0WRDATA5 (P0WRDATA_IN[5], P0WRDATA[5]);
  buf B_P0WRDATA6 (P0WRDATA_IN[6], P0WRDATA[6]);
  buf B_P0WRDATA7 (P0WRDATA_IN[7], P0WRDATA[7]);
  buf B_P0WRDATA8 (P0WRDATA_IN[8], P0WRDATA[8]);
  buf B_P0WRDATA9 (P0WRDATA_IN[9], P0WRDATA[9]);
  buf B_P0WREN (P0WREN_IN, P0WREN);
  buf B_P1ARBEN (P1ARBEN_IN, P1ARBEN);
  buf B_P1CMDBA0 (P1CMDBA_IN[0], P1CMDBA[0]);
  buf B_P1CMDBA1 (P1CMDBA_IN[1], P1CMDBA[1]);
  buf B_P1CMDBA2 (P1CMDBA_IN[2], P1CMDBA[2]);
  buf B_P1CMDBL0 (P1CMDBL_IN[0], P1CMDBL[0]);
  buf B_P1CMDBL1 (P1CMDBL_IN[1], P1CMDBL[1]);
  buf B_P1CMDBL2 (P1CMDBL_IN[2], P1CMDBL[2]);
  buf B_P1CMDBL3 (P1CMDBL_IN[3], P1CMDBL[3]);
  buf B_P1CMDBL4 (P1CMDBL_IN[4], P1CMDBL[4]);
  buf B_P1CMDBL5 (P1CMDBL_IN[5], P1CMDBL[5]);
  buf B_P1CMDCA0 (P1CMDCA_IN[0], P1CMDCA[0]);
  buf B_P1CMDCA1 (P1CMDCA_IN[1], P1CMDCA[1]);
  buf B_P1CMDCA10 (P1CMDCA_IN[10], P1CMDCA[10]);
  buf B_P1CMDCA11 (P1CMDCA_IN[11], P1CMDCA[11]);
  buf B_P1CMDCA2 (P1CMDCA_IN[2], P1CMDCA[2]);
  buf B_P1CMDCA3 (P1CMDCA_IN[3], P1CMDCA[3]);
  buf B_P1CMDCA4 (P1CMDCA_IN[4], P1CMDCA[4]);
  buf B_P1CMDCA5 (P1CMDCA_IN[5], P1CMDCA[5]);
  buf B_P1CMDCA6 (P1CMDCA_IN[6], P1CMDCA[6]);
  buf B_P1CMDCA7 (P1CMDCA_IN[7], P1CMDCA[7]);
  buf B_P1CMDCA8 (P1CMDCA_IN[8], P1CMDCA[8]);
  buf B_P1CMDCA9 (P1CMDCA_IN[9], P1CMDCA[9]);
  buf B_P1CMDCLK (P1CMDCLK_IN, P1CMDCLK);
  buf B_P1CMDEN (P1CMDEN_IN, P1CMDEN);
  buf B_P1CMDINSTR0 (P1CMDINSTR_IN[0], P1CMDINSTR[0]);
  buf B_P1CMDINSTR1 (P1CMDINSTR_IN[1], P1CMDINSTR[1]);
  buf B_P1CMDINSTR2 (P1CMDINSTR_IN[2], P1CMDINSTR[2]);
  buf B_P1CMDRA0 (P1CMDRA_IN[0], P1CMDRA[0]);
  buf B_P1CMDRA1 (P1CMDRA_IN[1], P1CMDRA[1]);
  buf B_P1CMDRA10 (P1CMDRA_IN[10], P1CMDRA[10]);
  buf B_P1CMDRA11 (P1CMDRA_IN[11], P1CMDRA[11]);
  buf B_P1CMDRA12 (P1CMDRA_IN[12], P1CMDRA[12]);
  buf B_P1CMDRA13 (P1CMDRA_IN[13], P1CMDRA[13]);
  buf B_P1CMDRA14 (P1CMDRA_IN[14], P1CMDRA[14]);
  buf B_P1CMDRA2 (P1CMDRA_IN[2], P1CMDRA[2]);
  buf B_P1CMDRA3 (P1CMDRA_IN[3], P1CMDRA[3]);
  buf B_P1CMDRA4 (P1CMDRA_IN[4], P1CMDRA[4]);
  buf B_P1CMDRA5 (P1CMDRA_IN[5], P1CMDRA[5]);
  buf B_P1CMDRA6 (P1CMDRA_IN[6], P1CMDRA[6]);
  buf B_P1CMDRA7 (P1CMDRA_IN[7], P1CMDRA[7]);
  buf B_P1CMDRA8 (P1CMDRA_IN[8], P1CMDRA[8]);
  buf B_P1CMDRA9 (P1CMDRA_IN[9], P1CMDRA[9]);
  buf B_P1RDCLK (P1RDCLK_IN, P1RDCLK);
  buf B_P1RDEN (P1RDEN_IN, P1RDEN);
  buf B_P1RWRMASK0 (P1RWRMASK_IN[0], P1RWRMASK[0]);
  buf B_P1RWRMASK1 (P1RWRMASK_IN[1], P1RWRMASK[1]);
  buf B_P1RWRMASK2 (P1RWRMASK_IN[2], P1RWRMASK[2]);
  buf B_P1RWRMASK3 (P1RWRMASK_IN[3], P1RWRMASK[3]);
  buf B_P1WRCLK (P1WRCLK_IN, P1WRCLK);
  buf B_P1WRDATA0 (P1WRDATA_IN[0], P1WRDATA[0]);
  buf B_P1WRDATA1 (P1WRDATA_IN[1], P1WRDATA[1]);
  buf B_P1WRDATA10 (P1WRDATA_IN[10], P1WRDATA[10]);
  buf B_P1WRDATA11 (P1WRDATA_IN[11], P1WRDATA[11]);
  buf B_P1WRDATA12 (P1WRDATA_IN[12], P1WRDATA[12]);
  buf B_P1WRDATA13 (P1WRDATA_IN[13], P1WRDATA[13]);
  buf B_P1WRDATA14 (P1WRDATA_IN[14], P1WRDATA[14]);
  buf B_P1WRDATA15 (P1WRDATA_IN[15], P1WRDATA[15]);
  buf B_P1WRDATA16 (P1WRDATA_IN[16], P1WRDATA[16]);
  buf B_P1WRDATA17 (P1WRDATA_IN[17], P1WRDATA[17]);
  buf B_P1WRDATA18 (P1WRDATA_IN[18], P1WRDATA[18]);
  buf B_P1WRDATA19 (P1WRDATA_IN[19], P1WRDATA[19]);
  buf B_P1WRDATA2 (P1WRDATA_IN[2], P1WRDATA[2]);
  buf B_P1WRDATA20 (P1WRDATA_IN[20], P1WRDATA[20]);
  buf B_P1WRDATA21 (P1WRDATA_IN[21], P1WRDATA[21]);
  buf B_P1WRDATA22 (P1WRDATA_IN[22], P1WRDATA[22]);
  buf B_P1WRDATA23 (P1WRDATA_IN[23], P1WRDATA[23]);
  buf B_P1WRDATA24 (P1WRDATA_IN[24], P1WRDATA[24]);
  buf B_P1WRDATA25 (P1WRDATA_IN[25], P1WRDATA[25]);
  buf B_P1WRDATA26 (P1WRDATA_IN[26], P1WRDATA[26]);
  buf B_P1WRDATA27 (P1WRDATA_IN[27], P1WRDATA[27]);
  buf B_P1WRDATA28 (P1WRDATA_IN[28], P1WRDATA[28]);
  buf B_P1WRDATA29 (P1WRDATA_IN[29], P1WRDATA[29]);
  buf B_P1WRDATA3 (P1WRDATA_IN[3], P1WRDATA[3]);
  buf B_P1WRDATA30 (P1WRDATA_IN[30], P1WRDATA[30]);
  buf B_P1WRDATA31 (P1WRDATA_IN[31], P1WRDATA[31]);
  buf B_P1WRDATA4 (P1WRDATA_IN[4], P1WRDATA[4]);
  buf B_P1WRDATA5 (P1WRDATA_IN[5], P1WRDATA[5]);
  buf B_P1WRDATA6 (P1WRDATA_IN[6], P1WRDATA[6]);
  buf B_P1WRDATA7 (P1WRDATA_IN[7], P1WRDATA[7]);
  buf B_P1WRDATA8 (P1WRDATA_IN[8], P1WRDATA[8]);
  buf B_P1WRDATA9 (P1WRDATA_IN[9], P1WRDATA[9]);
  buf B_P1WREN (P1WREN_IN, P1WREN);
  buf B_P2ARBEN (P2ARBEN_IN, P2ARBEN);
  buf B_P2CLK (P2CLK_IN, P2CLK);
  buf B_P2CMDBA0 (P2CMDBA_IN[0], P2CMDBA[0]);
  buf B_P2CMDBA1 (P2CMDBA_IN[1], P2CMDBA[1]);
  buf B_P2CMDBA2 (P2CMDBA_IN[2], P2CMDBA[2]);
  buf B_P2CMDBL0 (P2CMDBL_IN[0], P2CMDBL[0]);
  buf B_P2CMDBL1 (P2CMDBL_IN[1], P2CMDBL[1]);
  buf B_P2CMDBL2 (P2CMDBL_IN[2], P2CMDBL[2]);
  buf B_P2CMDBL3 (P2CMDBL_IN[3], P2CMDBL[3]);
  buf B_P2CMDBL4 (P2CMDBL_IN[4], P2CMDBL[4]);
  buf B_P2CMDBL5 (P2CMDBL_IN[5], P2CMDBL[5]);
  buf B_P2CMDCA0 (P2CMDCA_IN[0], P2CMDCA[0]);
  buf B_P2CMDCA1 (P2CMDCA_IN[1], P2CMDCA[1]);
  buf B_P2CMDCA10 (P2CMDCA_IN[10], P2CMDCA[10]);
  buf B_P2CMDCA11 (P2CMDCA_IN[11], P2CMDCA[11]);
  buf B_P2CMDCA2 (P2CMDCA_IN[2], P2CMDCA[2]);
  buf B_P2CMDCA3 (P2CMDCA_IN[3], P2CMDCA[3]);
  buf B_P2CMDCA4 (P2CMDCA_IN[4], P2CMDCA[4]);
  buf B_P2CMDCA5 (P2CMDCA_IN[5], P2CMDCA[5]);
  buf B_P2CMDCA6 (P2CMDCA_IN[6], P2CMDCA[6]);
  buf B_P2CMDCA7 (P2CMDCA_IN[7], P2CMDCA[7]);
  buf B_P2CMDCA8 (P2CMDCA_IN[8], P2CMDCA[8]);
  buf B_P2CMDCA9 (P2CMDCA_IN[9], P2CMDCA[9]);
  buf B_P2CMDCLK (P2CMDCLK_IN, P2CMDCLK);
  buf B_P2CMDEN (P2CMDEN_IN, P2CMDEN);
  buf B_P2CMDINSTR0 (P2CMDINSTR_IN[0], P2CMDINSTR[0]);
  buf B_P2CMDINSTR1 (P2CMDINSTR_IN[1], P2CMDINSTR[1]);
  buf B_P2CMDINSTR2 (P2CMDINSTR_IN[2], P2CMDINSTR[2]);
  buf B_P2CMDRA0 (P2CMDRA_IN[0], P2CMDRA[0]);
  buf B_P2CMDRA1 (P2CMDRA_IN[1], P2CMDRA[1]);
  buf B_P2CMDRA10 (P2CMDRA_IN[10], P2CMDRA[10]);
  buf B_P2CMDRA11 (P2CMDRA_IN[11], P2CMDRA[11]);
  buf B_P2CMDRA12 (P2CMDRA_IN[12], P2CMDRA[12]);
  buf B_P2CMDRA13 (P2CMDRA_IN[13], P2CMDRA[13]);
  buf B_P2CMDRA14 (P2CMDRA_IN[14], P2CMDRA[14]);
  buf B_P2CMDRA2 (P2CMDRA_IN[2], P2CMDRA[2]);
  buf B_P2CMDRA3 (P2CMDRA_IN[3], P2CMDRA[3]);
  buf B_P2CMDRA4 (P2CMDRA_IN[4], P2CMDRA[4]);
  buf B_P2CMDRA5 (P2CMDRA_IN[5], P2CMDRA[5]);
  buf B_P2CMDRA6 (P2CMDRA_IN[6], P2CMDRA[6]);
  buf B_P2CMDRA7 (P2CMDRA_IN[7], P2CMDRA[7]);
  buf B_P2CMDRA8 (P2CMDRA_IN[8], P2CMDRA[8]);
  buf B_P2CMDRA9 (P2CMDRA_IN[9], P2CMDRA[9]);
  buf B_P2EN (P2EN_IN, P2EN);
  buf B_P2WRDATA0 (P2WRDATA_IN[0], P2WRDATA[0]);
  buf B_P2WRDATA1 (P2WRDATA_IN[1], P2WRDATA[1]);
  buf B_P2WRDATA10 (P2WRDATA_IN[10], P2WRDATA[10]);
  buf B_P2WRDATA11 (P2WRDATA_IN[11], P2WRDATA[11]);
  buf B_P2WRDATA12 (P2WRDATA_IN[12], P2WRDATA[12]);
  buf B_P2WRDATA13 (P2WRDATA_IN[13], P2WRDATA[13]);
  buf B_P2WRDATA14 (P2WRDATA_IN[14], P2WRDATA[14]);
  buf B_P2WRDATA15 (P2WRDATA_IN[15], P2WRDATA[15]);
  buf B_P2WRDATA16 (P2WRDATA_IN[16], P2WRDATA[16]);
  buf B_P2WRDATA17 (P2WRDATA_IN[17], P2WRDATA[17]);
  buf B_P2WRDATA18 (P2WRDATA_IN[18], P2WRDATA[18]);
  buf B_P2WRDATA19 (P2WRDATA_IN[19], P2WRDATA[19]);
  buf B_P2WRDATA2 (P2WRDATA_IN[2], P2WRDATA[2]);
  buf B_P2WRDATA20 (P2WRDATA_IN[20], P2WRDATA[20]);
  buf B_P2WRDATA21 (P2WRDATA_IN[21], P2WRDATA[21]);
  buf B_P2WRDATA22 (P2WRDATA_IN[22], P2WRDATA[22]);
  buf B_P2WRDATA23 (P2WRDATA_IN[23], P2WRDATA[23]);
  buf B_P2WRDATA24 (P2WRDATA_IN[24], P2WRDATA[24]);
  buf B_P2WRDATA25 (P2WRDATA_IN[25], P2WRDATA[25]);
  buf B_P2WRDATA26 (P2WRDATA_IN[26], P2WRDATA[26]);
  buf B_P2WRDATA27 (P2WRDATA_IN[27], P2WRDATA[27]);
  buf B_P2WRDATA28 (P2WRDATA_IN[28], P2WRDATA[28]);
  buf B_P2WRDATA29 (P2WRDATA_IN[29], P2WRDATA[29]);
  buf B_P2WRDATA3 (P2WRDATA_IN[3], P2WRDATA[3]);
  buf B_P2WRDATA30 (P2WRDATA_IN[30], P2WRDATA[30]);
  buf B_P2WRDATA31 (P2WRDATA_IN[31], P2WRDATA[31]);
  buf B_P2WRDATA4 (P2WRDATA_IN[4], P2WRDATA[4]);
  buf B_P2WRDATA5 (P2WRDATA_IN[5], P2WRDATA[5]);
  buf B_P2WRDATA6 (P2WRDATA_IN[6], P2WRDATA[6]);
  buf B_P2WRDATA7 (P2WRDATA_IN[7], P2WRDATA[7]);
  buf B_P2WRDATA8 (P2WRDATA_IN[8], P2WRDATA[8]);
  buf B_P2WRDATA9 (P2WRDATA_IN[9], P2WRDATA[9]);
  buf B_P2WRMASK0 (P2WRMASK_IN[0], P2WRMASK[0]);
  buf B_P2WRMASK1 (P2WRMASK_IN[1], P2WRMASK[1]);
  buf B_P2WRMASK2 (P2WRMASK_IN[2], P2WRMASK[2]);
  buf B_P2WRMASK3 (P2WRMASK_IN[3], P2WRMASK[3]);
  buf B_P3ARBEN (P3ARBEN_IN, P3ARBEN);
  buf B_P3CLK (P3CLK_IN, P3CLK);
  buf B_P3CMDBA0 (P3CMDBA_IN[0], P3CMDBA[0]);
  buf B_P3CMDBA1 (P3CMDBA_IN[1], P3CMDBA[1]);
  buf B_P3CMDBA2 (P3CMDBA_IN[2], P3CMDBA[2]);
  buf B_P3CMDBL0 (P3CMDBL_IN[0], P3CMDBL[0]);
  buf B_P3CMDBL1 (P3CMDBL_IN[1], P3CMDBL[1]);
  buf B_P3CMDBL2 (P3CMDBL_IN[2], P3CMDBL[2]);
  buf B_P3CMDBL3 (P3CMDBL_IN[3], P3CMDBL[3]);
  buf B_P3CMDBL4 (P3CMDBL_IN[4], P3CMDBL[4]);
  buf B_P3CMDBL5 (P3CMDBL_IN[5], P3CMDBL[5]);
  buf B_P3CMDCA0 (P3CMDCA_IN[0], P3CMDCA[0]);
  buf B_P3CMDCA1 (P3CMDCA_IN[1], P3CMDCA[1]);
  buf B_P3CMDCA10 (P3CMDCA_IN[10], P3CMDCA[10]);
  buf B_P3CMDCA11 (P3CMDCA_IN[11], P3CMDCA[11]);
  buf B_P3CMDCA2 (P3CMDCA_IN[2], P3CMDCA[2]);
  buf B_P3CMDCA3 (P3CMDCA_IN[3], P3CMDCA[3]);
  buf B_P3CMDCA4 (P3CMDCA_IN[4], P3CMDCA[4]);
  buf B_P3CMDCA5 (P3CMDCA_IN[5], P3CMDCA[5]);
  buf B_P3CMDCA6 (P3CMDCA_IN[6], P3CMDCA[6]);
  buf B_P3CMDCA7 (P3CMDCA_IN[7], P3CMDCA[7]);
  buf B_P3CMDCA8 (P3CMDCA_IN[8], P3CMDCA[8]);
  buf B_P3CMDCA9 (P3CMDCA_IN[9], P3CMDCA[9]);
  buf B_P3CMDCLK (P3CMDCLK_IN, P3CMDCLK);
  buf B_P3CMDEN (P3CMDEN_IN, P3CMDEN);
  buf B_P3CMDINSTR0 (P3CMDINSTR_IN[0], P3CMDINSTR[0]);
  buf B_P3CMDINSTR1 (P3CMDINSTR_IN[1], P3CMDINSTR[1]);
  buf B_P3CMDINSTR2 (P3CMDINSTR_IN[2], P3CMDINSTR[2]);
  buf B_P3CMDRA0 (P3CMDRA_IN[0], P3CMDRA[0]);
  buf B_P3CMDRA1 (P3CMDRA_IN[1], P3CMDRA[1]);
  buf B_P3CMDRA10 (P3CMDRA_IN[10], P3CMDRA[10]);
  buf B_P3CMDRA11 (P3CMDRA_IN[11], P3CMDRA[11]);
  buf B_P3CMDRA12 (P3CMDRA_IN[12], P3CMDRA[12]);
  buf B_P3CMDRA13 (P3CMDRA_IN[13], P3CMDRA[13]);
  buf B_P3CMDRA14 (P3CMDRA_IN[14], P3CMDRA[14]);
  buf B_P3CMDRA2 (P3CMDRA_IN[2], P3CMDRA[2]);
  buf B_P3CMDRA3 (P3CMDRA_IN[3], P3CMDRA[3]);
  buf B_P3CMDRA4 (P3CMDRA_IN[4], P3CMDRA[4]);
  buf B_P3CMDRA5 (P3CMDRA_IN[5], P3CMDRA[5]);
  buf B_P3CMDRA6 (P3CMDRA_IN[6], P3CMDRA[6]);
  buf B_P3CMDRA7 (P3CMDRA_IN[7], P3CMDRA[7]);
  buf B_P3CMDRA8 (P3CMDRA_IN[8], P3CMDRA[8]);
  buf B_P3CMDRA9 (P3CMDRA_IN[9], P3CMDRA[9]);
  buf B_P3EN (P3EN_IN, P3EN);
  buf B_P3WRDATA0 (P3WRDATA_IN[0], P3WRDATA[0]);
  buf B_P3WRDATA1 (P3WRDATA_IN[1], P3WRDATA[1]);
  buf B_P3WRDATA10 (P3WRDATA_IN[10], P3WRDATA[10]);
  buf B_P3WRDATA11 (P3WRDATA_IN[11], P3WRDATA[11]);
  buf B_P3WRDATA12 (P3WRDATA_IN[12], P3WRDATA[12]);
  buf B_P3WRDATA13 (P3WRDATA_IN[13], P3WRDATA[13]);
  buf B_P3WRDATA14 (P3WRDATA_IN[14], P3WRDATA[14]);
  buf B_P3WRDATA15 (P3WRDATA_IN[15], P3WRDATA[15]);
  buf B_P3WRDATA16 (P3WRDATA_IN[16], P3WRDATA[16]);
  buf B_P3WRDATA17 (P3WRDATA_IN[17], P3WRDATA[17]);
  buf B_P3WRDATA18 (P3WRDATA_IN[18], P3WRDATA[18]);
  buf B_P3WRDATA19 (P3WRDATA_IN[19], P3WRDATA[19]);
  buf B_P3WRDATA2 (P3WRDATA_IN[2], P3WRDATA[2]);
  buf B_P3WRDATA20 (P3WRDATA_IN[20], P3WRDATA[20]);
  buf B_P3WRDATA21 (P3WRDATA_IN[21], P3WRDATA[21]);
  buf B_P3WRDATA22 (P3WRDATA_IN[22], P3WRDATA[22]);
  buf B_P3WRDATA23 (P3WRDATA_IN[23], P3WRDATA[23]);
  buf B_P3WRDATA24 (P3WRDATA_IN[24], P3WRDATA[24]);
  buf B_P3WRDATA25 (P3WRDATA_IN[25], P3WRDATA[25]);
  buf B_P3WRDATA26 (P3WRDATA_IN[26], P3WRDATA[26]);
  buf B_P3WRDATA27 (P3WRDATA_IN[27], P3WRDATA[27]);
  buf B_P3WRDATA28 (P3WRDATA_IN[28], P3WRDATA[28]);
  buf B_P3WRDATA29 (P3WRDATA_IN[29], P3WRDATA[29]);
  buf B_P3WRDATA3 (P3WRDATA_IN[3], P3WRDATA[3]);
  buf B_P3WRDATA30 (P3WRDATA_IN[30], P3WRDATA[30]);
  buf B_P3WRDATA31 (P3WRDATA_IN[31], P3WRDATA[31]);
  buf B_P3WRDATA4 (P3WRDATA_IN[4], P3WRDATA[4]);
  buf B_P3WRDATA5 (P3WRDATA_IN[5], P3WRDATA[5]);
  buf B_P3WRDATA6 (P3WRDATA_IN[6], P3WRDATA[6]);
  buf B_P3WRDATA7 (P3WRDATA_IN[7], P3WRDATA[7]);
  buf B_P3WRDATA8 (P3WRDATA_IN[8], P3WRDATA[8]);
  buf B_P3WRDATA9 (P3WRDATA_IN[9], P3WRDATA[9]);
  buf B_P3WRMASK0 (P3WRMASK_IN[0], P3WRMASK[0]);
  buf B_P3WRMASK1 (P3WRMASK_IN[1], P3WRMASK[1]);
  buf B_P3WRMASK2 (P3WRMASK_IN[2], P3WRMASK[2]);
  buf B_P3WRMASK3 (P3WRMASK_IN[3], P3WRMASK[3]);
  buf B_P4ARBEN (P4ARBEN_IN, P4ARBEN);
  buf B_P4CLK (P4CLK_IN, P4CLK);
  buf B_P4CMDBA0 (P4CMDBA_IN[0], P4CMDBA[0]);
  buf B_P4CMDBA1 (P4CMDBA_IN[1], P4CMDBA[1]);
  buf B_P4CMDBA2 (P4CMDBA_IN[2], P4CMDBA[2]);
  buf B_P4CMDBL0 (P4CMDBL_IN[0], P4CMDBL[0]);
  buf B_P4CMDBL1 (P4CMDBL_IN[1], P4CMDBL[1]);
  buf B_P4CMDBL2 (P4CMDBL_IN[2], P4CMDBL[2]);
  buf B_P4CMDBL3 (P4CMDBL_IN[3], P4CMDBL[3]);
  buf B_P4CMDBL4 (P4CMDBL_IN[4], P4CMDBL[4]);
  buf B_P4CMDBL5 (P4CMDBL_IN[5], P4CMDBL[5]);
  buf B_P4CMDCA0 (P4CMDCA_IN[0], P4CMDCA[0]);
  buf B_P4CMDCA1 (P4CMDCA_IN[1], P4CMDCA[1]);
  buf B_P4CMDCA10 (P4CMDCA_IN[10], P4CMDCA[10]);
  buf B_P4CMDCA11 (P4CMDCA_IN[11], P4CMDCA[11]);
  buf B_P4CMDCA2 (P4CMDCA_IN[2], P4CMDCA[2]);
  buf B_P4CMDCA3 (P4CMDCA_IN[3], P4CMDCA[3]);
  buf B_P4CMDCA4 (P4CMDCA_IN[4], P4CMDCA[4]);
  buf B_P4CMDCA5 (P4CMDCA_IN[5], P4CMDCA[5]);
  buf B_P4CMDCA6 (P4CMDCA_IN[6], P4CMDCA[6]);
  buf B_P4CMDCA7 (P4CMDCA_IN[7], P4CMDCA[7]);
  buf B_P4CMDCA8 (P4CMDCA_IN[8], P4CMDCA[8]);
  buf B_P4CMDCA9 (P4CMDCA_IN[9], P4CMDCA[9]);
  buf B_P4CMDCLK (P4CMDCLK_IN, P4CMDCLK);
  buf B_P4CMDEN (P4CMDEN_IN, P4CMDEN);
  buf B_P4CMDINSTR0 (P4CMDINSTR_IN[0], P4CMDINSTR[0]);
  buf B_P4CMDINSTR1 (P4CMDINSTR_IN[1], P4CMDINSTR[1]);
  buf B_P4CMDINSTR2 (P4CMDINSTR_IN[2], P4CMDINSTR[2]);
  buf B_P4CMDRA0 (P4CMDRA_IN[0], P4CMDRA[0]);
  buf B_P4CMDRA1 (P4CMDRA_IN[1], P4CMDRA[1]);
  buf B_P4CMDRA10 (P4CMDRA_IN[10], P4CMDRA[10]);
  buf B_P4CMDRA11 (P4CMDRA_IN[11], P4CMDRA[11]);
  buf B_P4CMDRA12 (P4CMDRA_IN[12], P4CMDRA[12]);
  buf B_P4CMDRA13 (P4CMDRA_IN[13], P4CMDRA[13]);
  buf B_P4CMDRA14 (P4CMDRA_IN[14], P4CMDRA[14]);
  buf B_P4CMDRA2 (P4CMDRA_IN[2], P4CMDRA[2]);
  buf B_P4CMDRA3 (P4CMDRA_IN[3], P4CMDRA[3]);
  buf B_P4CMDRA4 (P4CMDRA_IN[4], P4CMDRA[4]);
  buf B_P4CMDRA5 (P4CMDRA_IN[5], P4CMDRA[5]);
  buf B_P4CMDRA6 (P4CMDRA_IN[6], P4CMDRA[6]);
  buf B_P4CMDRA7 (P4CMDRA_IN[7], P4CMDRA[7]);
  buf B_P4CMDRA8 (P4CMDRA_IN[8], P4CMDRA[8]);
  buf B_P4CMDRA9 (P4CMDRA_IN[9], P4CMDRA[9]);
  buf B_P4EN (P4EN_IN, P4EN);
  buf B_P4WRDATA0 (P4WRDATA_IN[0], P4WRDATA[0]);
  buf B_P4WRDATA1 (P4WRDATA_IN[1], P4WRDATA[1]);
  buf B_P4WRDATA10 (P4WRDATA_IN[10], P4WRDATA[10]);
  buf B_P4WRDATA11 (P4WRDATA_IN[11], P4WRDATA[11]);
  buf B_P4WRDATA12 (P4WRDATA_IN[12], P4WRDATA[12]);
  buf B_P4WRDATA13 (P4WRDATA_IN[13], P4WRDATA[13]);
  buf B_P4WRDATA14 (P4WRDATA_IN[14], P4WRDATA[14]);
  buf B_P4WRDATA15 (P4WRDATA_IN[15], P4WRDATA[15]);
  buf B_P4WRDATA16 (P4WRDATA_IN[16], P4WRDATA[16]);
  buf B_P4WRDATA17 (P4WRDATA_IN[17], P4WRDATA[17]);
  buf B_P4WRDATA18 (P4WRDATA_IN[18], P4WRDATA[18]);
  buf B_P4WRDATA19 (P4WRDATA_IN[19], P4WRDATA[19]);
  buf B_P4WRDATA2 (P4WRDATA_IN[2], P4WRDATA[2]);
  buf B_P4WRDATA20 (P4WRDATA_IN[20], P4WRDATA[20]);
  buf B_P4WRDATA21 (P4WRDATA_IN[21], P4WRDATA[21]);
  buf B_P4WRDATA22 (P4WRDATA_IN[22], P4WRDATA[22]);
  buf B_P4WRDATA23 (P4WRDATA_IN[23], P4WRDATA[23]);
  buf B_P4WRDATA24 (P4WRDATA_IN[24], P4WRDATA[24]);
  buf B_P4WRDATA25 (P4WRDATA_IN[25], P4WRDATA[25]);
  buf B_P4WRDATA26 (P4WRDATA_IN[26], P4WRDATA[26]);
  buf B_P4WRDATA27 (P4WRDATA_IN[27], P4WRDATA[27]);
  buf B_P4WRDATA28 (P4WRDATA_IN[28], P4WRDATA[28]);
  buf B_P4WRDATA29 (P4WRDATA_IN[29], P4WRDATA[29]);
  buf B_P4WRDATA3 (P4WRDATA_IN[3], P4WRDATA[3]);
  buf B_P4WRDATA30 (P4WRDATA_IN[30], P4WRDATA[30]);
  buf B_P4WRDATA31 (P4WRDATA_IN[31], P4WRDATA[31]);
  buf B_P4WRDATA4 (P4WRDATA_IN[4], P4WRDATA[4]);
  buf B_P4WRDATA5 (P4WRDATA_IN[5], P4WRDATA[5]);
  buf B_P4WRDATA6 (P4WRDATA_IN[6], P4WRDATA[6]);
  buf B_P4WRDATA7 (P4WRDATA_IN[7], P4WRDATA[7]);
  buf B_P4WRDATA8 (P4WRDATA_IN[8], P4WRDATA[8]);
  buf B_P4WRDATA9 (P4WRDATA_IN[9], P4WRDATA[9]);
  buf B_P4WRMASK0 (P4WRMASK_IN[0], P4WRMASK[0]);
  buf B_P4WRMASK1 (P4WRMASK_IN[1], P4WRMASK[1]);
  buf B_P4WRMASK2 (P4WRMASK_IN[2], P4WRMASK[2]);
  buf B_P4WRMASK3 (P4WRMASK_IN[3], P4WRMASK[3]);
  buf B_P5ARBEN (P5ARBEN_IN, P5ARBEN);
  buf B_P5CLK (P5CLK_IN, P5CLK);
  buf B_P5CMDBA0 (P5CMDBA_IN[0], P5CMDBA[0]);
  buf B_P5CMDBA1 (P5CMDBA_IN[1], P5CMDBA[1]);
  buf B_P5CMDBA2 (P5CMDBA_IN[2], P5CMDBA[2]);
  buf B_P5CMDBL0 (P5CMDBL_IN[0], P5CMDBL[0]);
  buf B_P5CMDBL1 (P5CMDBL_IN[1], P5CMDBL[1]);
  buf B_P5CMDBL2 (P5CMDBL_IN[2], P5CMDBL[2]);
  buf B_P5CMDBL3 (P5CMDBL_IN[3], P5CMDBL[3]);
  buf B_P5CMDBL4 (P5CMDBL_IN[4], P5CMDBL[4]);
  buf B_P5CMDBL5 (P5CMDBL_IN[5], P5CMDBL[5]);
  buf B_P5CMDCA0 (P5CMDCA_IN[0], P5CMDCA[0]);
  buf B_P5CMDCA1 (P5CMDCA_IN[1], P5CMDCA[1]);
  buf B_P5CMDCA10 (P5CMDCA_IN[10], P5CMDCA[10]);
  buf B_P5CMDCA11 (P5CMDCA_IN[11], P5CMDCA[11]);
  buf B_P5CMDCA2 (P5CMDCA_IN[2], P5CMDCA[2]);
  buf B_P5CMDCA3 (P5CMDCA_IN[3], P5CMDCA[3]);
  buf B_P5CMDCA4 (P5CMDCA_IN[4], P5CMDCA[4]);
  buf B_P5CMDCA5 (P5CMDCA_IN[5], P5CMDCA[5]);
  buf B_P5CMDCA6 (P5CMDCA_IN[6], P5CMDCA[6]);
  buf B_P5CMDCA7 (P5CMDCA_IN[7], P5CMDCA[7]);
  buf B_P5CMDCA8 (P5CMDCA_IN[8], P5CMDCA[8]);
  buf B_P5CMDCA9 (P5CMDCA_IN[9], P5CMDCA[9]);
  buf B_P5CMDCLK (P5CMDCLK_IN, P5CMDCLK);
  buf B_P5CMDEN (P5CMDEN_IN, P5CMDEN);
  buf B_P5CMDINSTR0 (P5CMDINSTR_IN[0], P5CMDINSTR[0]);
  buf B_P5CMDINSTR1 (P5CMDINSTR_IN[1], P5CMDINSTR[1]);
  buf B_P5CMDINSTR2 (P5CMDINSTR_IN[2], P5CMDINSTR[2]);
  buf B_P5CMDRA0 (P5CMDRA_IN[0], P5CMDRA[0]);
  buf B_P5CMDRA1 (P5CMDRA_IN[1], P5CMDRA[1]);
  buf B_P5CMDRA10 (P5CMDRA_IN[10], P5CMDRA[10]);
  buf B_P5CMDRA11 (P5CMDRA_IN[11], P5CMDRA[11]);
  buf B_P5CMDRA12 (P5CMDRA_IN[12], P5CMDRA[12]);
  buf B_P5CMDRA13 (P5CMDRA_IN[13], P5CMDRA[13]);
  buf B_P5CMDRA14 (P5CMDRA_IN[14], P5CMDRA[14]);
  buf B_P5CMDRA2 (P5CMDRA_IN[2], P5CMDRA[2]);
  buf B_P5CMDRA3 (P5CMDRA_IN[3], P5CMDRA[3]);
  buf B_P5CMDRA4 (P5CMDRA_IN[4], P5CMDRA[4]);
  buf B_P5CMDRA5 (P5CMDRA_IN[5], P5CMDRA[5]);
  buf B_P5CMDRA6 (P5CMDRA_IN[6], P5CMDRA[6]);
  buf B_P5CMDRA7 (P5CMDRA_IN[7], P5CMDRA[7]);
  buf B_P5CMDRA8 (P5CMDRA_IN[8], P5CMDRA[8]);
  buf B_P5CMDRA9 (P5CMDRA_IN[9], P5CMDRA[9]);
  buf B_P5EN (P5EN_IN, P5EN);
  buf B_P5WRDATA0 (P5WRDATA_IN[0], P5WRDATA[0]);
  buf B_P5WRDATA1 (P5WRDATA_IN[1], P5WRDATA[1]);
  buf B_P5WRDATA10 (P5WRDATA_IN[10], P5WRDATA[10]);
  buf B_P5WRDATA11 (P5WRDATA_IN[11], P5WRDATA[11]);
  buf B_P5WRDATA12 (P5WRDATA_IN[12], P5WRDATA[12]);
  buf B_P5WRDATA13 (P5WRDATA_IN[13], P5WRDATA[13]);
  buf B_P5WRDATA14 (P5WRDATA_IN[14], P5WRDATA[14]);
  buf B_P5WRDATA15 (P5WRDATA_IN[15], P5WRDATA[15]);
  buf B_P5WRDATA16 (P5WRDATA_IN[16], P5WRDATA[16]);
  buf B_P5WRDATA17 (P5WRDATA_IN[17], P5WRDATA[17]);
  buf B_P5WRDATA18 (P5WRDATA_IN[18], P5WRDATA[18]);
  buf B_P5WRDATA19 (P5WRDATA_IN[19], P5WRDATA[19]);
  buf B_P5WRDATA2 (P5WRDATA_IN[2], P5WRDATA[2]);
  buf B_P5WRDATA20 (P5WRDATA_IN[20], P5WRDATA[20]);
  buf B_P5WRDATA21 (P5WRDATA_IN[21], P5WRDATA[21]);
  buf B_P5WRDATA22 (P5WRDATA_IN[22], P5WRDATA[22]);
  buf B_P5WRDATA23 (P5WRDATA_IN[23], P5WRDATA[23]);
  buf B_P5WRDATA24 (P5WRDATA_IN[24], P5WRDATA[24]);
  buf B_P5WRDATA25 (P5WRDATA_IN[25], P5WRDATA[25]);
  buf B_P5WRDATA26 (P5WRDATA_IN[26], P5WRDATA[26]);
  buf B_P5WRDATA27 (P5WRDATA_IN[27], P5WRDATA[27]);
  buf B_P5WRDATA28 (P5WRDATA_IN[28], P5WRDATA[28]);
  buf B_P5WRDATA29 (P5WRDATA_IN[29], P5WRDATA[29]);
  buf B_P5WRDATA3 (P5WRDATA_IN[3], P5WRDATA[3]);
  buf B_P5WRDATA30 (P5WRDATA_IN[30], P5WRDATA[30]);
  buf B_P5WRDATA31 (P5WRDATA_IN[31], P5WRDATA[31]);
  buf B_P5WRDATA4 (P5WRDATA_IN[4], P5WRDATA[4]);
  buf B_P5WRDATA5 (P5WRDATA_IN[5], P5WRDATA[5]);
  buf B_P5WRDATA6 (P5WRDATA_IN[6], P5WRDATA[6]);
  buf B_P5WRDATA7 (P5WRDATA_IN[7], P5WRDATA[7]);
  buf B_P5WRDATA8 (P5WRDATA_IN[8], P5WRDATA[8]);
  buf B_P5WRDATA9 (P5WRDATA_IN[9], P5WRDATA[9]);
  buf B_P5WRMASK0 (P5WRMASK_IN[0], P5WRMASK[0]);
  buf B_P5WRMASK1 (P5WRMASK_IN[1], P5WRMASK[1]);
  buf B_P5WRMASK2 (P5WRMASK_IN[2], P5WRMASK[2]);
  buf B_P5WRMASK3 (P5WRMASK_IN[3], P5WRMASK[3]);
  buf B_PLLCE0 (PLLCE_IN[0], PLLCE[0]);
  buf B_PLLCE1 (PLLCE_IN[1], PLLCE[1]);
  buf B_PLLCLK0 (PLLCLK_IN[0], PLLCLK[0]);
  buf B_PLLCLK1 (PLLCLK_IN[1], PLLCLK[1]);
  buf B_PLLLOCK (PLLLOCK_IN, PLLLOCK);
  buf B_RECAL (RECAL_IN, RECAL);
  buf B_SELFREFRESHENTER (SELFREFRESHENTER_IN, SELFREFRESHENTER);
  buf B_SYSRST (SYSRST_IN, SYSRST);
  buf B_UDQSIOIN (UDQSIOIN_IN, UDQSIOIN);
  buf B_UDQSIOIP (UDQSIOIP_IN, UDQSIOIP);
  buf B_UIADD (UIADD_IN, UIADD);
  buf B_UIADDR0 (UIADDR_IN[0], UIADDR[0]);
  buf B_UIADDR1 (UIADDR_IN[1], UIADDR[1]);
  buf B_UIADDR2 (UIADDR_IN[2], UIADDR[2]);
  buf B_UIADDR3 (UIADDR_IN[3], UIADDR[3]);
  buf B_UIADDR4 (UIADDR_IN[4], UIADDR[4]);
  buf B_UIBROADCAST (UIBROADCAST_IN, UIBROADCAST);
  buf B_UICLK (UICLK_IN, UICLK);
  buf B_UICMD (UICMD_IN, UICMD);
  buf B_UICMDEN (UICMDEN_IN, UICMDEN);
  buf B_UICMDIN (UICMDIN_IN, UICMDIN);
  buf B_UICS (UICS_IN, UICS);
  buf B_UIDONECAL (UIDONECAL_IN, UIDONECAL);
  buf B_UIDQCOUNT0 (UIDQCOUNT_IN[0], UIDQCOUNT[0]);
  buf B_UIDQCOUNT1 (UIDQCOUNT_IN[1], UIDQCOUNT[1]);
  buf B_UIDQCOUNT2 (UIDQCOUNT_IN[2], UIDQCOUNT[2]);
  buf B_UIDQCOUNT3 (UIDQCOUNT_IN[3], UIDQCOUNT[3]);
  buf B_UIDQLOWERDEC (UIDQLOWERDEC_IN, UIDQLOWERDEC);
  buf B_UIDQLOWERINC (UIDQLOWERINC_IN, UIDQLOWERINC);
  buf B_UIDQUPPERDEC (UIDQUPPERDEC_IN, UIDQUPPERDEC);
  buf B_UIDQUPPERINC (UIDQUPPERINC_IN, UIDQUPPERINC);
  buf B_UIDRPUPDATE (UIDRPUPDATE_IN, UIDRPUPDATE);
  buf B_UILDQSDEC (UILDQSDEC_IN, UILDQSDEC);
  buf B_UILDQSINC (UILDQSINC_IN, UILDQSINC);
  buf B_UIREAD (UIREAD_IN, UIREAD);
  buf B_UISDI (UISDI_IN, UISDI);
  buf B_UIUDQSDEC (UIUDQSDEC_IN, UIUDQSDEC);
  buf B_UIUDQSINC (UIUDQSINC_IN, UIUDQSINC);

  wire [14:0] delay_ADDR;
  wire [15:0] delay_DQON;
  wire [15:0] delay_DQOP;
  wire [2:0] delay_BA;
  wire [31:0] delay_P0RDDATA;
  wire [31:0] delay_P1RDDATA;
  wire [31:0] delay_P2RDDATA;
  wire [31:0] delay_P3RDDATA;
  wire [31:0] delay_P4RDDATA;
  wire [31:0] delay_P5RDDATA;
  wire [31:0] delay_STATUS;
  wire [4:0] delay_IOIDRPADDR;
  wire [6:0] delay_P0RDCOUNT;
  wire [6:0] delay_P0WRCOUNT;
  wire [6:0] delay_P1RDCOUNT;
  wire [6:0] delay_P1WRCOUNT;
  wire [6:0] delay_P2COUNT;
  wire [6:0] delay_P3COUNT;
  wire [6:0] delay_P4COUNT;
  wire [6:0] delay_P5COUNT;
  wire [7:0] delay_UODATA;
  wire delay_CAS;
  wire delay_CKE;
  wire delay_DQIOWEN0;
  wire delay_DQSIOWEN90N;
  wire delay_DQSIOWEN90P;
  wire delay_IOIDRPADD;
  wire delay_IOIDRPBROADCAST;
  wire delay_IOIDRPCLK;
  wire delay_IOIDRPCS;
  wire delay_IOIDRPSDO;
  wire delay_IOIDRPTRAIN;
  wire delay_IOIDRPUPDATE;
  wire delay_LDMN;
  wire delay_LDMP;
  wire delay_ODT;
  wire delay_P0CMDEMPTY;
  wire delay_P0CMDFULL;
  wire delay_P0RDEMPTY;
  wire delay_P0RDERROR;
  wire delay_P0RDFULL;
  wire delay_P0RDOVERFLOW;
  wire delay_P0WREMPTY;
  wire delay_P0WRERROR;
  wire delay_P0WRFULL;
  wire delay_P0WRUNDERRUN;
  wire delay_P1CMDEMPTY;
  wire delay_P1CMDFULL;
  wire delay_P1RDEMPTY;
  wire delay_P1RDERROR;
  wire delay_P1RDFULL;
  wire delay_P1RDOVERFLOW;
  wire delay_P1WREMPTY;
  wire delay_P1WRERROR;
  wire delay_P1WRFULL;
  wire delay_P1WRUNDERRUN;
  wire delay_P2CMDEMPTY;
  wire delay_P2CMDFULL;
  wire delay_P2EMPTY;
  wire delay_P2ERROR;
  wire delay_P2FULL;
  wire delay_P2RDOVERFLOW;
  wire delay_P2WRUNDERRUN;
  wire delay_P3CMDEMPTY;
  wire delay_P3CMDFULL;
  wire delay_P3EMPTY;
  wire delay_P3ERROR;
  wire delay_P3FULL;
  wire delay_P3RDOVERFLOW;
  wire delay_P3WRUNDERRUN;
  wire delay_P4CMDEMPTY;
  wire delay_P4CMDFULL;
  wire delay_P4EMPTY;
  wire delay_P4ERROR;
  wire delay_P4FULL;
  wire delay_P4RDOVERFLOW;
  wire delay_P4WRUNDERRUN;
  wire delay_P5CMDEMPTY;
  wire delay_P5CMDFULL;
  wire delay_P5EMPTY;
  wire delay_P5ERROR;
  wire delay_P5FULL;
  wire delay_P5RDOVERFLOW;
  wire delay_P5WRUNDERRUN;
  wire delay_RAS;
  wire delay_RST;
  wire delay_SELFREFRESHMODE;
  wire delay_UDMN;
  wire delay_UDMP;
  wire delay_UOCALSTART;
  wire delay_UOCMDREADYIN;
  wire delay_UODATAVALID;
  wire delay_UODONECAL;
  wire delay_UOREFRSHFLAG;
  wire delay_UOSDO;
  wire delay_WE;

  wire [11:0] delay_P0CMDCA;
  wire [11:0] delay_P1CMDCA;
  wire [11:0] delay_P2CMDCA;
  wire [11:0] delay_P3CMDCA;
  wire [11:0] delay_P4CMDCA;
  wire [11:0] delay_P5CMDCA;
  wire [14:0] delay_P0CMDRA;
  wire [14:0] delay_P1CMDRA;
  wire [14:0] delay_P2CMDRA;
  wire [14:0] delay_P3CMDRA;
  wire [14:0] delay_P4CMDRA;
  wire [14:0] delay_P5CMDRA;
  wire [15:0] delay_DQI;
  wire [1:0] delay_PLLCE;
  wire [1:0] delay_PLLCLK;
  wire [2:0] delay_P0CMDBA;
  wire [2:0] delay_P0CMDINSTR;
  wire [2:0] delay_P1CMDBA;
  wire [2:0] delay_P1CMDINSTR;
  wire [2:0] delay_P2CMDBA;
  wire [2:0] delay_P2CMDINSTR;
  wire [2:0] delay_P3CMDBA;
  wire [2:0] delay_P3CMDINSTR;
  wire [2:0] delay_P4CMDBA;
  wire [2:0] delay_P4CMDINSTR;
  wire [2:0] delay_P5CMDBA;
  wire [2:0] delay_P5CMDINSTR;
  wire [31:0] delay_P0WRDATA;
  wire [31:0] delay_P1WRDATA;
  wire [31:0] delay_P2WRDATA;
  wire [31:0] delay_P3WRDATA;
  wire [31:0] delay_P4WRDATA;
  wire [31:0] delay_P5WRDATA;
  wire [3:0] delay_P0RWRMASK;
  wire [3:0] delay_P1RWRMASK;
  wire [3:0] delay_P2WRMASK;
  wire [3:0] delay_P3WRMASK;
  wire [3:0] delay_P4WRMASK;
  wire [3:0] delay_P5WRMASK;
  wire [3:0] delay_UIDQCOUNT;
  wire [4:0] delay_UIADDR;
  wire [5:0] delay_P0CMDBL;
  wire [5:0] delay_P1CMDBL;
  wire [5:0] delay_P2CMDBL;
  wire [5:0] delay_P3CMDBL;
  wire [5:0] delay_P4CMDBL;
  wire [5:0] delay_P5CMDBL;
  wire delay_DQSIOIN;
  wire delay_DQSIOIP;
  wire delay_IOIDRPSDI;
  wire delay_P0ARBEN;
  wire delay_P0CMDCLK;
  wire delay_P0CMDEN;
  wire delay_P0RDCLK;
  wire delay_P0RDEN;
  wire delay_P0WRCLK;
  wire delay_P0WREN;
  wire delay_P1ARBEN;
  wire delay_P1CMDCLK;
  wire delay_P1CMDEN;
  wire delay_P1RDCLK;
  wire delay_P1RDEN;
  wire delay_P1WRCLK;
  wire delay_P1WREN;
  wire delay_P2ARBEN;
  wire delay_P2CLK;
  wire delay_P2CMDCLK;
  wire delay_P2CMDEN;
  wire delay_P2EN;
  wire delay_P3ARBEN;
  wire delay_P3CLK;
  wire delay_P3CMDCLK;
  wire delay_P3CMDEN;
  wire delay_P3EN;
  wire delay_P4ARBEN;
  wire delay_P4CLK;
  wire delay_P4CMDCLK;
  wire delay_P4CMDEN;
  wire delay_P4EN;
  wire delay_P5ARBEN;
  wire delay_P5CLK;
  wire delay_P5CMDCLK;
  wire delay_P5CMDEN;
  wire delay_P5EN;
  wire delay_PLLLOCK;
  wire delay_RECAL;
  wire delay_SELFREFRESHENTER;
  wire delay_SYSRST;
  wire delay_UDQSIOIN;
  wire delay_UDQSIOIP;
  wire delay_UIADD;
  wire delay_UIBROADCAST;
  wire delay_UICLK;
  wire delay_UICMD;
  wire delay_UICMDEN;
  wire delay_UICMDIN;
  wire delay_UICS;
  wire delay_UIDONECAL;
  wire delay_UIDQLOWERDEC;
  wire delay_UIDQLOWERINC;
  wire delay_UIDQUPPERDEC;
  wire delay_UIDQUPPERINC;
  wire delay_UIDRPUPDATE;
  wire delay_UILDQSDEC;
  wire delay_UILDQSINC;
  wire delay_UIREAD;
  wire delay_UISDI;
  wire delay_UIUDQSDEC;
  wire delay_UIUDQSINC;


  assign #(out_delay) ADDR_OUT = delay_ADDR;
  assign #(out_delay) BA_OUT = delay_BA;
  assign #(out_delay) CAS_OUT = delay_CAS;
  assign #(out_delay) CKE_OUT = delay_CKE;
  assign #(out_delay) DQIOWEN0_OUT = delay_DQIOWEN0;
  assign #(out_delay) DQON_OUT = delay_DQON;
  assign #(out_delay) DQOP_OUT = delay_DQOP;
  assign #(out_delay) DQSIOWEN90N_OUT = delay_DQSIOWEN90N;
  assign #(out_delay) DQSIOWEN90P_OUT = delay_DQSIOWEN90P;
  assign #(out_delay) IOIDRPADDR_OUT = delay_IOIDRPADDR;
  assign #(out_delay) IOIDRPADD_OUT = delay_IOIDRPADD;
  assign #(out_delay) IOIDRPBROADCAST_OUT = delay_IOIDRPBROADCAST;
  assign #(out_delay) IOIDRPCLK_OUT = delay_IOIDRPCLK;
  assign #(out_delay) IOIDRPCS_OUT = delay_IOIDRPCS;
  assign #(out_delay) IOIDRPSDO_OUT = delay_IOIDRPSDO;
  assign #(out_delay) IOIDRPTRAIN_OUT = delay_IOIDRPTRAIN;
  assign #(out_delay) IOIDRPUPDATE_OUT = delay_IOIDRPUPDATE;
  assign #(out_delay) LDMN_OUT = delay_LDMN;
  assign #(out_delay) LDMP_OUT = delay_LDMP;
  assign #(out_delay) ODT_OUT = delay_ODT;
  assign #(out_delay) P0CMDEMPTY_OUT = delay_P0CMDEMPTY;
  assign #(out_delay) P0CMDFULL_OUT = delay_P0CMDFULL;
  assign #(out_delay) P0RDCOUNT_OUT = delay_P0RDCOUNT;
  assign #(out_delay) P0RDDATA_OUT = delay_P0RDDATA;
  assign #(out_delay) P0RDEMPTY_OUT = delay_P0RDEMPTY;
  assign #(out_delay) P0RDERROR_OUT = delay_P0RDERROR;
  assign #(out_delay) P0RDFULL_OUT = delay_P0RDFULL;
  assign #(out_delay) P0RDOVERFLOW_OUT = delay_P0RDOVERFLOW;
  assign #(out_delay) P0WRCOUNT_OUT = delay_P0WRCOUNT;
  assign #(out_delay) P0WREMPTY_OUT = delay_P0WREMPTY;
  assign #(out_delay) P0WRERROR_OUT = delay_P0WRERROR;
  assign #(out_delay) P0WRFULL_OUT = delay_P0WRFULL;
  assign #(out_delay) P0WRUNDERRUN_OUT = delay_P0WRUNDERRUN;
  assign #(out_delay) P1CMDEMPTY_OUT = delay_P1CMDEMPTY;
  assign #(out_delay) P1CMDFULL_OUT = delay_P1CMDFULL;
  assign #(out_delay) P1RDCOUNT_OUT = delay_P1RDCOUNT;
  assign #(out_delay) P1RDDATA_OUT = delay_P1RDDATA;
  assign #(out_delay) P1RDEMPTY_OUT = delay_P1RDEMPTY;
  assign #(out_delay) P1RDERROR_OUT = delay_P1RDERROR;
  assign #(out_delay) P1RDFULL_OUT = delay_P1RDFULL;
  assign #(out_delay) P1RDOVERFLOW_OUT = delay_P1RDOVERFLOW;
  assign #(out_delay) P1WRCOUNT_OUT = delay_P1WRCOUNT;
  assign #(out_delay) P1WREMPTY_OUT = delay_P1WREMPTY;
  assign #(out_delay) P1WRERROR_OUT = delay_P1WRERROR;
  assign #(out_delay) P1WRFULL_OUT = delay_P1WRFULL;
  assign #(out_delay) P1WRUNDERRUN_OUT = delay_P1WRUNDERRUN;
  assign #(out_delay) P2CMDEMPTY_OUT = delay_P2CMDEMPTY;
  assign #(out_delay) P2CMDFULL_OUT = delay_P2CMDFULL;
  assign #(out_delay) P2COUNT_OUT = delay_P2COUNT;
  assign #(out_delay) P2EMPTY_OUT = delay_P2EMPTY;
  assign #(out_delay) P2ERROR_OUT = delay_P2ERROR;
  assign #(out_delay) P2FULL_OUT = delay_P2FULL;
  assign #(out_delay) P2RDDATA_OUT = delay_P2RDDATA;
  assign #(out_delay) P2RDOVERFLOW_OUT = delay_P2RDOVERFLOW;
  assign #(out_delay) P2WRUNDERRUN_OUT = delay_P2WRUNDERRUN;
  assign #(out_delay) P3CMDEMPTY_OUT = delay_P3CMDEMPTY;
  assign #(out_delay) P3CMDFULL_OUT = delay_P3CMDFULL;
  assign #(out_delay) P3COUNT_OUT = delay_P3COUNT;
  assign #(out_delay) P3EMPTY_OUT = delay_P3EMPTY;
  assign #(out_delay) P3ERROR_OUT = delay_P3ERROR;
  assign #(out_delay) P3FULL_OUT = delay_P3FULL;
  assign #(out_delay) P3RDDATA_OUT = delay_P3RDDATA;
  assign #(out_delay) P3RDOVERFLOW_OUT = delay_P3RDOVERFLOW;
  assign #(out_delay) P3WRUNDERRUN_OUT = delay_P3WRUNDERRUN;
  assign #(out_delay) P4CMDEMPTY_OUT = delay_P4CMDEMPTY;
  assign #(out_delay) P4CMDFULL_OUT = delay_P4CMDFULL;
  assign #(out_delay) P4COUNT_OUT = delay_P4COUNT;
  assign #(out_delay) P4EMPTY_OUT = delay_P4EMPTY;
  assign #(out_delay) P4ERROR_OUT = delay_P4ERROR;
  assign #(out_delay) P4FULL_OUT = delay_P4FULL;
  assign #(out_delay) P4RDDATA_OUT = delay_P4RDDATA;
  assign #(out_delay) P4RDOVERFLOW_OUT = delay_P4RDOVERFLOW;
  assign #(out_delay) P4WRUNDERRUN_OUT = delay_P4WRUNDERRUN;
  assign #(out_delay) P5CMDEMPTY_OUT = delay_P5CMDEMPTY;
  assign #(out_delay) P5CMDFULL_OUT = delay_P5CMDFULL;
  assign #(out_delay) P5COUNT_OUT = delay_P5COUNT;
  assign #(out_delay) P5EMPTY_OUT = delay_P5EMPTY;
  assign #(out_delay) P5ERROR_OUT = delay_P5ERROR;
  assign #(out_delay) P5FULL_OUT = delay_P5FULL;
  assign #(out_delay) P5RDDATA_OUT = delay_P5RDDATA;
  assign #(out_delay) P5RDOVERFLOW_OUT = delay_P5RDOVERFLOW;
  assign #(out_delay) P5WRUNDERRUN_OUT = delay_P5WRUNDERRUN;
  assign #(out_delay) RAS_OUT = delay_RAS;
  assign #(out_delay) RST_OUT = delay_RST;
  assign #(out_delay) SELFREFRESHMODE_OUT = delay_SELFREFRESHMODE;
  assign #(out_delay) STATUS_OUT = delay_STATUS;
  assign #(out_delay) UDMN_OUT = delay_UDMN;
  assign #(out_delay) UDMP_OUT = delay_UDMP;
  assign #(out_delay) UOCALSTART_OUT = delay_UOCALSTART;
  assign #(out_delay) UOCMDREADYIN_OUT = delay_UOCMDREADYIN;
  assign #(out_delay) UODATAVALID_OUT = delay_UODATAVALID;
  assign #(out_delay) UODATA_OUT = delay_UODATA;
  assign #(out_delay) UODONECAL_OUT = delay_UODONECAL;
  assign #(out_delay) UOREFRSHFLAG_OUT = delay_UOREFRSHFLAG;
  assign #(out_delay) UOSDO_OUT = delay_UOSDO;
  assign #(out_delay) WE_OUT = delay_WE;

  assign #(INCLK_DELAY) DQSIOIN_INDELAY = DQSIOIN_IN;
  assign #(INCLK_DELAY) DQSIOIP_INDELAY = DQSIOIP_IN;
  assign #(INCLK_DELAY) P0CMDCLK_INDELAY = P0CMDCLK_IN;
  assign #(INCLK_DELAY) P0RDCLK_INDELAY = P0RDCLK_IN;
  assign #(INCLK_DELAY) P0WRCLK_INDELAY = P0WRCLK_IN;
  assign #(INCLK_DELAY) P1CMDCLK_INDELAY = P1CMDCLK_IN;
  assign #(INCLK_DELAY) P1RDCLK_INDELAY = P1RDCLK_IN;
  assign #(INCLK_DELAY) P1WRCLK_INDELAY = P1WRCLK_IN;
  assign #(INCLK_DELAY) P2CLK_INDELAY = P2CLK_IN;
  assign #(INCLK_DELAY) P2CMDCLK_INDELAY = P2CMDCLK_IN;
  assign #(INCLK_DELAY) P3CLK_INDELAY = P3CLK_IN;
  assign #(INCLK_DELAY) P3CMDCLK_INDELAY = P3CMDCLK_IN;
  assign #(INCLK_DELAY) P4CLK_INDELAY = P4CLK_IN;
  assign #(INCLK_DELAY) P4CMDCLK_INDELAY = P4CMDCLK_IN;
  assign #(INCLK_DELAY) P5CLK_INDELAY = P5CLK_IN;
  assign #(INCLK_DELAY) P5CMDCLK_INDELAY = P5CMDCLK_IN;
  assign #(INCLK_DELAY) PLLCLK_INDELAY = PLLCLK_IN;
  assign #(INCLK_DELAY) UDQSIOIN_INDELAY = UDQSIOIN_IN;
  assign #(INCLK_DELAY) UDQSIOIP_INDELAY = UDQSIOIP_IN;
  assign #(INCLK_DELAY) UICLK_INDELAY = UICLK_IN;

  assign #(in_delay) DQI_INDELAY = DQI_IN;
  assign #(in_delay) IOIDRPSDI_INDELAY = IOIDRPSDI_IN;
  assign #(in_delay) P0ARBEN_INDELAY = P0ARBEN_IN;
  assign #(in_delay) P0CMDBA_INDELAY = P0CMDBA_IN;
  assign #(in_delay) P0CMDBL_INDELAY = P0CMDBL_IN;
  assign #(in_delay) P0CMDCA_INDELAY = P0CMDCA_IN;
  assign #(in_delay) P0CMDEN_INDELAY = P0CMDEN_IN;
  assign #(in_delay) P0CMDINSTR_INDELAY = P0CMDINSTR_IN;
  assign #(in_delay) P0CMDRA_INDELAY = P0CMDRA_IN;
  assign #(in_delay) P0RDEN_INDELAY = P0RDEN_IN;
  assign #(in_delay) P0RWRMASK_INDELAY = P0RWRMASK_IN;
  assign #(in_delay) P0WRDATA_INDELAY = P0WRDATA_IN;
  assign #(in_delay) P0WREN_INDELAY = P0WREN_IN;
  assign #(in_delay) P1ARBEN_INDELAY = P1ARBEN_IN;
  assign #(in_delay) P1CMDBA_INDELAY = P1CMDBA_IN;
  assign #(in_delay) P1CMDBL_INDELAY = P1CMDBL_IN;
  assign #(in_delay) P1CMDCA_INDELAY = P1CMDCA_IN;
  assign #(in_delay) P1CMDEN_INDELAY = P1CMDEN_IN;
  assign #(in_delay) P1CMDINSTR_INDELAY = P1CMDINSTR_IN;
  assign #(in_delay) P1CMDRA_INDELAY = P1CMDRA_IN;
  assign #(in_delay) P1RDEN_INDELAY = P1RDEN_IN;
  assign #(in_delay) P1RWRMASK_INDELAY = P1RWRMASK_IN;
  assign #(in_delay) P1WRDATA_INDELAY = P1WRDATA_IN;
  assign #(in_delay) P1WREN_INDELAY = P1WREN_IN;
  assign #(in_delay) P2ARBEN_INDELAY = P2ARBEN_IN;
  assign #(in_delay) P2CMDBA_INDELAY = P2CMDBA_IN;
  assign #(in_delay) P2CMDBL_INDELAY = P2CMDBL_IN;
  assign #(in_delay) P2CMDCA_INDELAY = P2CMDCA_IN;
  assign #(in_delay) P2CMDEN_INDELAY = P2CMDEN_IN;
  assign #(in_delay) P2CMDINSTR_INDELAY = P2CMDINSTR_IN;
  assign #(in_delay) P2CMDRA_INDELAY = P2CMDRA_IN;
  assign #(in_delay) P2EN_INDELAY = P2EN_IN;
  assign #(in_delay) P2WRDATA_INDELAY = P2WRDATA_IN;
  assign #(in_delay) P2WRMASK_INDELAY = P2WRMASK_IN;
  assign #(in_delay) P3ARBEN_INDELAY = P3ARBEN_IN;
  assign #(in_delay) P3CMDBA_INDELAY = P3CMDBA_IN;
  assign #(in_delay) P3CMDBL_INDELAY = P3CMDBL_IN;
  assign #(in_delay) P3CMDCA_INDELAY = P3CMDCA_IN;
  assign #(in_delay) P3CMDEN_INDELAY = P3CMDEN_IN;
  assign #(in_delay) P3CMDINSTR_INDELAY = P3CMDINSTR_IN;
  assign #(in_delay) P3CMDRA_INDELAY = P3CMDRA_IN;
  assign #(in_delay) P3EN_INDELAY = P3EN_IN;
  assign #(in_delay) P3WRDATA_INDELAY = P3WRDATA_IN;
  assign #(in_delay) P3WRMASK_INDELAY = P3WRMASK_IN;
  assign #(in_delay) P4ARBEN_INDELAY = P4ARBEN_IN;
  assign #(in_delay) P4CMDBA_INDELAY = P4CMDBA_IN;
  assign #(in_delay) P4CMDBL_INDELAY = P4CMDBL_IN;
  assign #(in_delay) P4CMDCA_INDELAY = P4CMDCA_IN;
  assign #(in_delay) P4CMDEN_INDELAY = P4CMDEN_IN;
  assign #(in_delay) P4CMDINSTR_INDELAY = P4CMDINSTR_IN;
  assign #(in_delay) P4CMDRA_INDELAY = P4CMDRA_IN;
  assign #(in_delay) P4EN_INDELAY = P4EN_IN;
  assign #(in_delay) P4WRDATA_INDELAY = P4WRDATA_IN;
  assign #(in_delay) P4WRMASK_INDELAY = P4WRMASK_IN;
  assign #(in_delay) P5ARBEN_INDELAY = P5ARBEN_IN;
  assign #(in_delay) P5CMDBA_INDELAY = P5CMDBA_IN;
  assign #(in_delay) P5CMDBL_INDELAY = P5CMDBL_IN;
  assign #(in_delay) P5CMDCA_INDELAY = P5CMDCA_IN;
  assign #(in_delay) P5CMDEN_INDELAY = P5CMDEN_IN;
  assign #(in_delay) P5CMDINSTR_INDELAY = P5CMDINSTR_IN;
  assign #(in_delay) P5CMDRA_INDELAY = P5CMDRA_IN;
  assign #(in_delay) P5EN_INDELAY = P5EN_IN;
  assign #(in_delay) P5WRDATA_INDELAY = P5WRDATA_IN;
  assign #(in_delay) P5WRMASK_INDELAY = P5WRMASK_IN;
  assign #(in_delay) PLLCE_INDELAY = PLLCE_IN;
  assign #(in_delay) PLLLOCK_INDELAY = PLLLOCK_IN;
  assign #(in_delay) RECAL_INDELAY = RECAL_IN;
  assign #(in_delay) SELFREFRESHENTER_INDELAY = SELFREFRESHENTER_IN;
  assign #(in_delay) SYSRST_INDELAY = SYSRST_IN;
  assign #(in_delay) UIADDR_INDELAY = UIADDR_IN;
  assign #(in_delay) UIADD_INDELAY = UIADD_IN;
  assign #(in_delay) UIBROADCAST_INDELAY = UIBROADCAST_IN;
  assign #(in_delay) UICMDEN_INDELAY = UICMDEN_IN;
  assign #(in_delay) UICMDIN_INDELAY = UICMDIN_IN;
  assign #(in_delay) UICMD_INDELAY = UICMD_IN;
  assign #(in_delay) UICS_INDELAY = UICS_IN;
  assign #(in_delay) UIDONECAL_INDELAY = UIDONECAL_IN;
  assign #(in_delay) UIDQCOUNT_INDELAY = UIDQCOUNT_IN;
  assign #(in_delay) UIDQLOWERDEC_INDELAY = UIDQLOWERDEC_IN;
  assign #(in_delay) UIDQLOWERINC_INDELAY = UIDQLOWERINC_IN;
  assign #(in_delay) UIDQUPPERDEC_INDELAY = UIDQUPPERDEC_IN;
  assign #(in_delay) UIDQUPPERINC_INDELAY = UIDQUPPERINC_IN;
  assign #(in_delay) UIDRPUPDATE_INDELAY = UIDRPUPDATE_IN;
  assign #(in_delay) UILDQSDEC_INDELAY = UILDQSDEC_IN;
  assign #(in_delay) UILDQSINC_INDELAY = UILDQSINC_IN;
  assign #(in_delay) UIREAD_INDELAY = UIREAD_IN;
  assign #(in_delay) UISDI_INDELAY = UISDI_IN;
  assign #(in_delay) UIUDQSDEC_INDELAY = UIUDQSDEC_IN;
  assign #(in_delay) UIUDQSINC_INDELAY = UIUDQSINC_IN;

  assign  delay_DQI = DQI_IN;
  assign  delay_SYSRST = SYSRST_INDELAY;
  assign  delay_DQSIOIN = DQSIOIN_INDELAY;
  assign  delay_DQSIOIP = DQSIOIP_INDELAY;
  assign  delay_UDQSIOIN = UDQSIOIN_INDELAY;
  assign  delay_UDQSIOIP = UDQSIOIP_INDELAY;

  B_MCB #(
    .ARB_NUM_TIME_SLOTS (ARB_NUM_TIME_SLOTS),
    .ARB_TIME_SLOT_0 (ARB_TIME_SLOT_0),
    .ARB_TIME_SLOT_1 (ARB_TIME_SLOT_1),
    .ARB_TIME_SLOT_10 (ARB_TIME_SLOT_10),
    .ARB_TIME_SLOT_11 (ARB_TIME_SLOT_11),
    .ARB_TIME_SLOT_2 (ARB_TIME_SLOT_2),
    .ARB_TIME_SLOT_3 (ARB_TIME_SLOT_3),
    .ARB_TIME_SLOT_4 (ARB_TIME_SLOT_4),
    .ARB_TIME_SLOT_5 (ARB_TIME_SLOT_5),
    .ARB_TIME_SLOT_6 (ARB_TIME_SLOT_6),
    .ARB_TIME_SLOT_7 (ARB_TIME_SLOT_7),
    .ARB_TIME_SLOT_8 (ARB_TIME_SLOT_8),
    .ARB_TIME_SLOT_9 (ARB_TIME_SLOT_9),
    .CAL_BA (CAL_BA),
    .CAL_BYPASS (CAL_BYPASS),
    .CAL_CA (CAL_CA),
    .CAL_CALIBRATION_MODE (CAL_CALIBRATION_MODE),
    .CAL_CLK_DIV (CAL_CLK_DIV),
    .CAL_DELAY (CAL_DELAY),
    .CAL_RA (CAL_RA),
    .MEM_ADDR_ORDER (MEM_ADDR_ORDER),
    .MEM_BA_SIZE (MEM_BA_SIZE),
    .MEM_BURST_LEN (MEM_BURST_LEN),
    .MEM_CAS_LATENCY (MEM_CAS_LATENCY),
    .MEM_CA_SIZE (MEM_CA_SIZE),
    .MEM_DDR1_2_ODS (MEM_DDR1_2_ODS),
    .MEM_DDR2_3_HIGH_TEMP_SR (MEM_DDR2_3_HIGH_TEMP_SR),
    .MEM_DDR2_3_PA_SR (MEM_DDR2_3_PA_SR),
    .MEM_DDR2_ADD_LATENCY (MEM_DDR2_ADD_LATENCY),
    .MEM_DDR2_DIFF_DQS_EN (MEM_DDR2_DIFF_DQS_EN),
    .MEM_DDR2_RTT (MEM_DDR2_RTT),
    .MEM_DDR2_WRT_RECOVERY (MEM_DDR2_WRT_RECOVERY),
    .MEM_DDR3_ADD_LATENCY (MEM_DDR3_ADD_LATENCY),
    .MEM_DDR3_AUTO_SR (MEM_DDR3_AUTO_SR),
    .MEM_DDR3_CAS_LATENCY (MEM_DDR3_CAS_LATENCY),
    .MEM_DDR3_CAS_WR_LATENCY (MEM_DDR3_CAS_WR_LATENCY),
    .MEM_DDR3_DYN_WRT_ODT (MEM_DDR3_DYN_WRT_ODT),
    .MEM_DDR3_ODS (MEM_DDR3_ODS),
    .MEM_DDR3_RTT (MEM_DDR3_RTT),
    .MEM_DDR3_WRT_RECOVERY (MEM_DDR3_WRT_RECOVERY),
    .MEM_MDDR_ODS (MEM_MDDR_ODS),
    .MEM_MOBILE_PA_SR (MEM_MOBILE_PA_SR),
    .MEM_MOBILE_TC_SR (MEM_MOBILE_TC_SR),
    .MEM_RAS_VAL (MEM_RAS_VAL),
    .MEM_RA_SIZE (MEM_RA_SIZE),
    .MEM_RCD_VAL (MEM_RCD_VAL),
    .MEM_REFI_VAL (MEM_REFI_VAL),
    .MEM_RFC_VAL (MEM_RFC_VAL),
    .MEM_RP_VAL (MEM_RP_VAL),
    .MEM_RTP_VAL (MEM_RTP_VAL),
    .MEM_TYPE (MEM_TYPE),
    .MEM_WIDTH (MEM_WIDTH),
    .MEM_WR_VAL (MEM_WR_VAL),
    .MEM_WTR_VAL (MEM_WTR_VAL),
    .PORT_CONFIG (PORT_CONFIG))

    B_X_MCB_INST (
    .ADDR (delay_ADDR),
    .BA (delay_BA),
    .CAS (delay_CAS),
    .CKE (delay_CKE),
    .DQIOWEN0 (delay_DQIOWEN0),
    .DQON (delay_DQON),
    .DQOP (delay_DQOP),
    .DQSIOWEN90N (delay_DQSIOWEN90N),
    .DQSIOWEN90P (delay_DQSIOWEN90P),
    .IOIDRPADD (delay_IOIDRPADD),
    .IOIDRPADDR (delay_IOIDRPADDR),
    .IOIDRPBROADCAST (delay_IOIDRPBROADCAST),
    .IOIDRPCLK (delay_IOIDRPCLK),
    .IOIDRPCS (delay_IOIDRPCS),
    .IOIDRPSDO (delay_IOIDRPSDO),
    .IOIDRPTRAIN (delay_IOIDRPTRAIN),
    .IOIDRPUPDATE (delay_IOIDRPUPDATE),
    .LDMN (delay_LDMN),
    .LDMP (delay_LDMP),
    .ODT (delay_ODT),
    .P0CMDEMPTY (delay_P0CMDEMPTY),
    .P0CMDFULL (delay_P0CMDFULL),
    .P0RDCOUNT (delay_P0RDCOUNT),
    .P0RDDATA (delay_P0RDDATA),
    .P0RDEMPTY (delay_P0RDEMPTY),
    .P0RDERROR (delay_P0RDERROR),
    .P0RDFULL (delay_P0RDFULL),
    .P0RDOVERFLOW (delay_P0RDOVERFLOW),
    .P0WRCOUNT (delay_P0WRCOUNT),
    .P0WREMPTY (delay_P0WREMPTY),
    .P0WRERROR (delay_P0WRERROR),
    .P0WRFULL (delay_P0WRFULL),
    .P0WRUNDERRUN (delay_P0WRUNDERRUN),
    .P1CMDEMPTY (delay_P1CMDEMPTY),
    .P1CMDFULL (delay_P1CMDFULL),
    .P1RDCOUNT (delay_P1RDCOUNT),
    .P1RDDATA (delay_P1RDDATA),
    .P1RDEMPTY (delay_P1RDEMPTY),
    .P1RDERROR (delay_P1RDERROR),
    .P1RDFULL (delay_P1RDFULL),
    .P1RDOVERFLOW (delay_P1RDOVERFLOW),
    .P1WRCOUNT (delay_P1WRCOUNT),
    .P1WREMPTY (delay_P1WREMPTY),
    .P1WRERROR (delay_P1WRERROR),
    .P1WRFULL (delay_P1WRFULL),
    .P1WRUNDERRUN (delay_P1WRUNDERRUN),
    .P2CMDEMPTY (delay_P2CMDEMPTY),
    .P2CMDFULL (delay_P2CMDFULL),
    .P2COUNT (delay_P2COUNT),
    .P2EMPTY (delay_P2EMPTY),
    .P2ERROR (delay_P2ERROR),
    .P2FULL (delay_P2FULL),
    .P2RDDATA (delay_P2RDDATA),
    .P2RDOVERFLOW (delay_P2RDOVERFLOW),
    .P2WRUNDERRUN (delay_P2WRUNDERRUN),
    .P3CMDEMPTY (delay_P3CMDEMPTY),
    .P3CMDFULL (delay_P3CMDFULL),
    .P3COUNT (delay_P3COUNT),
    .P3EMPTY (delay_P3EMPTY),
    .P3ERROR (delay_P3ERROR),
    .P3FULL (delay_P3FULL),
    .P3RDDATA (delay_P3RDDATA),
    .P3RDOVERFLOW (delay_P3RDOVERFLOW),
    .P3WRUNDERRUN (delay_P3WRUNDERRUN),
    .P4CMDEMPTY (delay_P4CMDEMPTY),
    .P4CMDFULL (delay_P4CMDFULL),
    .P4COUNT (delay_P4COUNT),
    .P4EMPTY (delay_P4EMPTY),
    .P4ERROR (delay_P4ERROR),
    .P4FULL (delay_P4FULL),
    .P4RDDATA (delay_P4RDDATA),
    .P4RDOVERFLOW (delay_P4RDOVERFLOW),
    .P4WRUNDERRUN (delay_P4WRUNDERRUN),
    .P5CMDEMPTY (delay_P5CMDEMPTY),
    .P5CMDFULL (delay_P5CMDFULL),
    .P5COUNT (delay_P5COUNT),
    .P5EMPTY (delay_P5EMPTY),
    .P5ERROR (delay_P5ERROR),
    .P5FULL (delay_P5FULL),
    .P5RDDATA (delay_P5RDDATA),
    .P5RDOVERFLOW (delay_P5RDOVERFLOW),
    .P5WRUNDERRUN (delay_P5WRUNDERRUN),
    .RAS (delay_RAS),
    .RST (delay_RST),
    .SELFREFRESHMODE (delay_SELFREFRESHMODE),
    .STATUS (delay_STATUS),
    .UDMN (delay_UDMN),
    .UDMP (delay_UDMP),
    .UOCALSTART (delay_UOCALSTART),
    .UOCMDREADYIN (delay_UOCMDREADYIN),
    .UODATA (delay_UODATA),
    .UODATAVALID (delay_UODATAVALID),
    .UODONECAL (delay_UODONECAL),
    .UOREFRSHFLAG (delay_UOREFRSHFLAG),
    .UOSDO (delay_UOSDO),
    .WE (delay_WE),
    .DQI (delay_DQI),
    .DQSIOIN (delay_DQSIOIN),
    .DQSIOIP (delay_DQSIOIP),
    .IOIDRPSDI (delay_IOIDRPSDI),
    .P0ARBEN (delay_P0ARBEN),
    .P0CMDBA (delay_P0CMDBA),
    .P0CMDBL (delay_P0CMDBL),
    .P0CMDCA (delay_P0CMDCA),
    .P0CMDCLK (delay_P0CMDCLK),
    .P0CMDEN (delay_P0CMDEN),
    .P0CMDINSTR (delay_P0CMDINSTR),
    .P0CMDRA (delay_P0CMDRA),
    .P0RDCLK (delay_P0RDCLK),
    .P0RDEN (delay_P0RDEN),
    .P0RWRMASK (delay_P0RWRMASK),
    .P0WRCLK (delay_P0WRCLK),
    .P0WRDATA (delay_P0WRDATA),
    .P0WREN (delay_P0WREN),
    .P1ARBEN (delay_P1ARBEN),
    .P1CMDBA (delay_P1CMDBA),
    .P1CMDBL (delay_P1CMDBL),
    .P1CMDCA (delay_P1CMDCA),
    .P1CMDCLK (delay_P1CMDCLK),
    .P1CMDEN (delay_P1CMDEN),
    .P1CMDINSTR (delay_P1CMDINSTR),
    .P1CMDRA (delay_P1CMDRA),
    .P1RDCLK (delay_P1RDCLK),
    .P1RDEN (delay_P1RDEN),
    .P1RWRMASK (delay_P1RWRMASK),
    .P1WRCLK (delay_P1WRCLK),
    .P1WRDATA (delay_P1WRDATA),
    .P1WREN (delay_P1WREN),
    .P2ARBEN (delay_P2ARBEN),
    .P2CLK (delay_P2CLK),
    .P2CMDBA (delay_P2CMDBA),
    .P2CMDBL (delay_P2CMDBL),
    .P2CMDCA (delay_P2CMDCA),
    .P2CMDCLK (delay_P2CMDCLK),
    .P2CMDEN (delay_P2CMDEN),
    .P2CMDINSTR (delay_P2CMDINSTR),
    .P2CMDRA (delay_P2CMDRA),
    .P2EN (delay_P2EN),
    .P2WRDATA (delay_P2WRDATA),
    .P2WRMASK (delay_P2WRMASK),
    .P3ARBEN (delay_P3ARBEN),
    .P3CLK (delay_P3CLK),
    .P3CMDBA (delay_P3CMDBA),
    .P3CMDBL (delay_P3CMDBL),
    .P3CMDCA (delay_P3CMDCA),
    .P3CMDCLK (delay_P3CMDCLK),
    .P3CMDEN (delay_P3CMDEN),
    .P3CMDINSTR (delay_P3CMDINSTR),
    .P3CMDRA (delay_P3CMDRA),
    .P3EN (delay_P3EN),
    .P3WRDATA (delay_P3WRDATA),
    .P3WRMASK (delay_P3WRMASK),
    .P4ARBEN (delay_P4ARBEN),
    .P4CLK (delay_P4CLK),
    .P4CMDBA (delay_P4CMDBA),
    .P4CMDBL (delay_P4CMDBL),
    .P4CMDCA (delay_P4CMDCA),
    .P4CMDCLK (delay_P4CMDCLK),
    .P4CMDEN (delay_P4CMDEN),
    .P4CMDINSTR (delay_P4CMDINSTR),
    .P4CMDRA (delay_P4CMDRA),
    .P4EN (delay_P4EN),
    .P4WRDATA (delay_P4WRDATA),
    .P4WRMASK (delay_P4WRMASK),
    .P5ARBEN (delay_P5ARBEN),
    .P5CLK (delay_P5CLK),
    .P5CMDBA (delay_P5CMDBA),
    .P5CMDBL (delay_P5CMDBL),
    .P5CMDCA (delay_P5CMDCA),
    .P5CMDCLK (delay_P5CMDCLK),
    .P5CMDEN (delay_P5CMDEN),
    .P5CMDINSTR (delay_P5CMDINSTR),
    .P5CMDRA (delay_P5CMDRA),
    .P5EN (delay_P5EN),
    .P5WRDATA (delay_P5WRDATA),
    .P5WRMASK (delay_P5WRMASK),
    .PLLCE (delay_PLLCE),
    .PLLCLK (delay_PLLCLK),
    .PLLLOCK (delay_PLLLOCK),
    .RECAL (delay_RECAL),
    .SELFREFRESHENTER (delay_SELFREFRESHENTER),
    .SYSRST (delay_SYSRST),
    .UDQSIOIN (delay_UDQSIOIN),
    .UDQSIOIP (delay_UDQSIOIP),
    .UIADD (delay_UIADD),
    .UIADDR (delay_UIADDR),
    .UIBROADCAST (delay_UIBROADCAST),
    .UICLK (delay_UICLK),
    .UICMD (delay_UICMD),
    .UICMDEN (delay_UICMDEN),
    .UICMDIN (delay_UICMDIN),
    .UICS (delay_UICS),
    .UIDONECAL (delay_UIDONECAL),
    .UIDQCOUNT (delay_UIDQCOUNT),
    .UIDQLOWERDEC (delay_UIDQLOWERDEC),
    .UIDQLOWERINC (delay_UIDQLOWERINC),
    .UIDQUPPERDEC (delay_UIDQUPPERDEC),
    .UIDQUPPERINC (delay_UIDQUPPERINC),
    .UIDRPUPDATE (delay_UIDRPUPDATE),
    .UILDQSDEC (delay_UILDQSDEC),
    .UILDQSINC (delay_UILDQSINC),
    .UIREAD (delay_UIREAD),
    .UISDI (delay_UISDI),
    .UIUDQSDEC (delay_UIUDQSDEC),
    .UIUDQSINC (delay_UIUDQSINC),
    .GSR (GSR)
  );

  specify
    $period (negedge P0CMDCLK, 0:0:0, notifier);
    $period (negedge P1CMDCLK, 0:0:0, notifier);
    $period (negedge P2CMDCLK, 0:0:0, notifier);
    $period (negedge P3CMDCLK, 0:0:0, notifier);
    $period (negedge P4CMDCLK, 0:0:0, notifier);
    $period (negedge P5CMDCLK, 0:0:0, notifier);
    $period (negedge PLLCLK[0], 0:0:0, notifier);
    $period (negedge PLLCLK[1], 0:0:0, notifier);
    $period (negedge SYSRST, 0:0:0, notifier);
    $period (negedge UICLK, 0:0:0, notifier);
    $period (posedge P0CMDCLK, 0:0:0, notifier);
    $period (posedge P0RDCLK, 0:0:0, notifier);
    $period (posedge P0WRCLK, 0:0:0, notifier);
    $period (posedge P1CMDCLK, 0:0:0, notifier);
    $period (posedge P1RDCLK, 0:0:0, notifier);
    $period (posedge P1WRCLK, 0:0:0, notifier);
    $period (posedge P2CLK, 0:0:0, notifier);
    $period (posedge P2CMDCLK, 0:0:0, notifier);
    $period (posedge P3CLK, 0:0:0, notifier);
    $period (posedge P3CMDCLK, 0:0:0, notifier);
    $period (posedge P4CLK, 0:0:0, notifier);
    $period (posedge P4CMDCLK, 0:0:0, notifier);
    $period (posedge P5CLK, 0:0:0, notifier);
    $period (posedge P5CMDCLK, 0:0:0, notifier);
    $period (posedge PLLCLK[0], 0:0:0, notifier);
    $period (posedge PLLCLK[1], 0:0:0, notifier);
    $period (posedge SYSRST, 0:0:0, notifier);
    $period (posedge UICLK, 0:0:0, notifier);
    $setuphold (negedge PLLCLK[1], negedge SELFREFRESHENTER, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_SELFREFRESHENTER);
    $setuphold (negedge PLLCLK[1], posedge SELFREFRESHENTER, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_SELFREFRESHENTER);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBA[0]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBA[1]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBA[2]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[0]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[1]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[2]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[3]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[4]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[5]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[0]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[10]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[11]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[1]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[2]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[3]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[4]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[5]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[6]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[7]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[8]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[9]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDEN);
    $setuphold (posedge P0CMDCLK, negedge P0CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDINSTR[0]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDINSTR[1]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDINSTR[2]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[0]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[10]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[11]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[12]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[13]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[14]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[1]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[2]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[3]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[4]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[5]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[6]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[7]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[8]);
    $setuphold (posedge P0CMDCLK, negedge P0CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[9]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBA[0]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBA[1]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBA[2]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[0]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[1]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[2]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[3]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[4]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDBL[5]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[0]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[10]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[11]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[1]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[2]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[3]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[4]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[5]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[6]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[7]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[8]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDCA[9]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDEN);
    $setuphold (posedge P0CMDCLK, posedge P0CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDINSTR[0]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDINSTR[1]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDINSTR[2]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[0]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[10]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[11]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[12]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[13]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[14]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[1]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[2]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[3]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[4]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[5]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[6]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[7]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[8]);
    $setuphold (posedge P0CMDCLK, posedge P0CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P0CMDCLK, delay_P0CMDRA[9]);
    $setuphold (posedge P0RDCLK, negedge P0RDEN, 0:0:0, 0:0:0, notifier,,, delay_P0RDCLK, delay_P0RDEN);
    $setuphold (posedge P0RDCLK, posedge P0RDEN, 0:0:0, 0:0:0, notifier,,, delay_P0RDCLK, delay_P0RDEN);
    $setuphold (posedge P0WRCLK, negedge P0RWRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[0]);
    $setuphold (posedge P0WRCLK, negedge P0RWRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[1]);
    $setuphold (posedge P0WRCLK, negedge P0RWRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[2]);
    $setuphold (posedge P0WRCLK, negedge P0RWRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[3]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[0]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[10]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[11]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[12]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[13]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[14]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[15]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[16]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[17]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[18]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[19]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[1]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[20]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[21]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[22]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[23]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[24]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[25]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[26]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[27]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[28]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[29]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[2]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[30]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[31]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[3]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[4]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[5]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[6]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[7]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[8]);
    $setuphold (posedge P0WRCLK, negedge P0WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[9]);
    $setuphold (posedge P0WRCLK, negedge P0WREN, 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WREN);
    $setuphold (posedge P0WRCLK, posedge P0RWRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[0]);
    $setuphold (posedge P0WRCLK, posedge P0RWRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[1]);
    $setuphold (posedge P0WRCLK, posedge P0RWRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[2]);
    $setuphold (posedge P0WRCLK, posedge P0RWRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0RWRMASK[3]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[0]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[10]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[11]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[12]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[13]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[14]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[15]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[16]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[17]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[18]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[19]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[1]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[20]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[21]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[22]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[23]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[24]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[25]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[26]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[27]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[28]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[29]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[2]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[30]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[31]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[3]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[4]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[5]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[6]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[7]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[8]);
    $setuphold (posedge P0WRCLK, posedge P0WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WRDATA[9]);
    $setuphold (posedge P0WRCLK, posedge P0WREN, 0:0:0, 0:0:0, notifier,,, delay_P0WRCLK, delay_P0WREN);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBA[0]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBA[1]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBA[2]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[0]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[1]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[2]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[3]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[4]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[5]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[0]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[10]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[11]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[1]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[2]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[3]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[4]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[5]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[6]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[7]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[8]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[9]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDEN);
    $setuphold (posedge P1CMDCLK, negedge P1CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDINSTR[0]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDINSTR[1]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDINSTR[2]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[0]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[10]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[11]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[12]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[13]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[14]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[1]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[2]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[3]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[4]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[5]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[6]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[7]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[8]);
    $setuphold (posedge P1CMDCLK, negedge P1CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[9]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBA[0]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBA[1]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBA[2]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[0]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[1]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[2]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[3]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[4]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDBL[5]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[0]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[10]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[11]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[1]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[2]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[3]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[4]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[5]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[6]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[7]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[8]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDCA[9]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDEN);
    $setuphold (posedge P1CMDCLK, posedge P1CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDINSTR[0]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDINSTR[1]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDINSTR[2]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[0]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[10]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[11]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[12]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[13]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[14]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[1]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[2]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[3]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[4]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[5]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[6]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[7]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[8]);
    $setuphold (posedge P1CMDCLK, posedge P1CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P1CMDCLK, delay_P1CMDRA[9]);
    $setuphold (posedge P1RDCLK, negedge P1RDEN, 0:0:0, 0:0:0, notifier,,, delay_P1RDCLK, delay_P1RDEN);
    $setuphold (posedge P1RDCLK, posedge P1RDEN, 0:0:0, 0:0:0, notifier,,, delay_P1RDCLK, delay_P1RDEN);
    $setuphold (posedge P1WRCLK, negedge P1RWRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[0]);
    $setuphold (posedge P1WRCLK, negedge P1RWRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[1]);
    $setuphold (posedge P1WRCLK, negedge P1RWRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[2]);
    $setuphold (posedge P1WRCLK, negedge P1RWRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[3]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[0]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[10]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[11]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[12]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[13]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[14]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[15]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[16]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[17]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[18]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[19]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[1]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[20]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[21]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[22]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[23]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[24]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[25]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[26]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[27]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[28]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[29]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[2]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[30]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[31]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[3]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[4]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[5]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[6]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[7]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[8]);
    $setuphold (posedge P1WRCLK, negedge P1WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[9]);
    $setuphold (posedge P1WRCLK, negedge P1WREN, 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WREN);
    $setuphold (posedge P1WRCLK, posedge P1RWRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[0]);
    $setuphold (posedge P1WRCLK, posedge P1RWRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[1]);
    $setuphold (posedge P1WRCLK, posedge P1RWRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[2]);
    $setuphold (posedge P1WRCLK, posedge P1RWRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1RWRMASK[3]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[0]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[10]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[11]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[12]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[13]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[14]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[15]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[16]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[17]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[18]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[19]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[1]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[20]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[21]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[22]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[23]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[24]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[25]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[26]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[27]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[28]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[29]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[2]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[30]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[31]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[3]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[4]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[5]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[6]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[7]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[8]);
    $setuphold (posedge P1WRCLK, posedge P1WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WRDATA[9]);
    $setuphold (posedge P1WRCLK, posedge P1WREN, 0:0:0, 0:0:0, notifier,,, delay_P1WRCLK, delay_P1WREN);
    $setuphold (posedge P2CLK, negedge P2EN, 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2EN);
    $setuphold (posedge P2CLK, negedge P2WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[0]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[10]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[11]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[12]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[13]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[14]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[15]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[16]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[17]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[18]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[19]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[1]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[20]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[21]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[22]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[23]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[24]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[25]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[26]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[27]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[28]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[29]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[2]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[30]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[31]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[3]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[4]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[5]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[6]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[7]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[8]);
    $setuphold (posedge P2CLK, negedge P2WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[9]);
    $setuphold (posedge P2CLK, negedge P2WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[0]);
    $setuphold (posedge P2CLK, negedge P2WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[1]);
    $setuphold (posedge P2CLK, negedge P2WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[2]);
    $setuphold (posedge P2CLK, negedge P2WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[3]);
    $setuphold (posedge P2CLK, posedge P2EN, 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2EN);
    $setuphold (posedge P2CLK, posedge P2WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[0]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[10]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[11]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[12]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[13]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[14]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[15]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[16]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[17]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[18]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[19]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[1]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[20]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[21]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[22]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[23]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[24]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[25]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[26]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[27]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[28]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[29]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[2]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[30]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[31]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[3]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[4]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[5]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[6]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[7]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[8]);
    $setuphold (posedge P2CLK, posedge P2WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRDATA[9]);
    $setuphold (posedge P2CLK, posedge P2WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[0]);
    $setuphold (posedge P2CLK, posedge P2WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[1]);
    $setuphold (posedge P2CLK, posedge P2WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[2]);
    $setuphold (posedge P2CLK, posedge P2WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P2CLK, delay_P2WRMASK[3]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBA[0]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBA[1]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBA[2]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[0]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[1]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[2]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[3]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[4]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[5]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[0]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[10]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[11]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[1]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[2]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[3]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[4]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[5]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[6]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[7]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[8]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[9]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDEN);
    $setuphold (posedge P2CMDCLK, negedge P2CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDINSTR[0]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDINSTR[1]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDINSTR[2]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[0]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[10]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[11]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[12]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[13]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[14]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[1]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[2]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[3]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[4]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[5]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[6]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[7]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[8]);
    $setuphold (posedge P2CMDCLK, negedge P2CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[9]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBA[0]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBA[1]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBA[2]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[0]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[1]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[2]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[3]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[4]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDBL[5]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[0]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[10]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[11]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[1]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[2]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[3]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[4]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[5]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[6]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[7]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[8]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDCA[9]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDEN);
    $setuphold (posedge P2CMDCLK, posedge P2CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDINSTR[0]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDINSTR[1]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDINSTR[2]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[0]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[10]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[11]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[12]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[13]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[14]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[1]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[2]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[3]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[4]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[5]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[6]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[7]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[8]);
    $setuphold (posedge P2CMDCLK, posedge P2CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P2CMDCLK, delay_P2CMDRA[9]);
    $setuphold (posedge P3CLK, negedge P3EN, 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3EN);
    $setuphold (posedge P3CLK, negedge P3WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[0]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[10]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[11]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[12]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[13]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[14]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[15]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[16]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[17]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[18]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[19]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[1]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[20]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[21]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[22]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[23]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[24]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[25]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[26]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[27]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[28]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[29]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[2]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[30]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[31]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[3]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[4]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[5]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[6]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[7]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[8]);
    $setuphold (posedge P3CLK, negedge P3WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[9]);
    $setuphold (posedge P3CLK, negedge P3WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[0]);
    $setuphold (posedge P3CLK, negedge P3WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[1]);
    $setuphold (posedge P3CLK, negedge P3WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[2]);
    $setuphold (posedge P3CLK, negedge P3WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[3]);
    $setuphold (posedge P3CLK, posedge P3EN, 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3EN);
    $setuphold (posedge P3CLK, posedge P3WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[0]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[10]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[11]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[12]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[13]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[14]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[15]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[16]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[17]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[18]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[19]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[1]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[20]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[21]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[22]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[23]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[24]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[25]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[26]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[27]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[28]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[29]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[2]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[30]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[31]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[3]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[4]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[5]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[6]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[7]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[8]);
    $setuphold (posedge P3CLK, posedge P3WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRDATA[9]);
    $setuphold (posedge P3CLK, posedge P3WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[0]);
    $setuphold (posedge P3CLK, posedge P3WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[1]);
    $setuphold (posedge P3CLK, posedge P3WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[2]);
    $setuphold (posedge P3CLK, posedge P3WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P3CLK, delay_P3WRMASK[3]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBA[0]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBA[1]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBA[2]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[0]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[1]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[2]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[3]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[4]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[5]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[0]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[10]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[11]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[1]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[2]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[3]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[4]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[5]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[6]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[7]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[8]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[9]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDEN);
    $setuphold (posedge P3CMDCLK, negedge P3CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDINSTR[0]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDINSTR[1]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDINSTR[2]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[0]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[10]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[11]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[12]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[13]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[14]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[1]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[2]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[3]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[4]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[5]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[6]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[7]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[8]);
    $setuphold (posedge P3CMDCLK, negedge P3CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[9]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBA[0]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBA[1]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBA[2]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[0]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[1]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[2]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[3]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[4]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDBL[5]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[0]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[10]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[11]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[1]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[2]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[3]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[4]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[5]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[6]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[7]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[8]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDCA[9]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDEN);
    $setuphold (posedge P3CMDCLK, posedge P3CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDINSTR[0]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDINSTR[1]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDINSTR[2]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[0]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[10]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[11]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[12]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[13]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[14]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[1]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[2]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[3]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[4]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[5]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[6]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[7]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[8]);
    $setuphold (posedge P3CMDCLK, posedge P3CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P3CMDCLK, delay_P3CMDRA[9]);
    $setuphold (posedge P4CLK, negedge P4EN, 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4EN);
    $setuphold (posedge P4CLK, negedge P4WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[0]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[10]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[11]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[12]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[13]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[14]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[15]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[16]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[17]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[18]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[19]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[1]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[20]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[21]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[22]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[23]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[24]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[25]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[26]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[27]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[28]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[29]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[2]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[30]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[31]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[3]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[4]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[5]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[6]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[7]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[8]);
    $setuphold (posedge P4CLK, negedge P4WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[9]);
    $setuphold (posedge P4CLK, negedge P4WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[0]);
    $setuphold (posedge P4CLK, negedge P4WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[1]);
    $setuphold (posedge P4CLK, negedge P4WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[2]);
    $setuphold (posedge P4CLK, negedge P4WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[3]);
    $setuphold (posedge P4CLK, posedge P4EN, 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4EN);
    $setuphold (posedge P4CLK, posedge P4WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[0]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[10]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[11]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[12]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[13]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[14]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[15]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[16]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[17]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[18]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[19]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[1]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[20]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[21]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[22]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[23]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[24]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[25]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[26]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[27]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[28]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[29]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[2]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[30]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[31]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[3]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[4]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[5]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[6]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[7]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[8]);
    $setuphold (posedge P4CLK, posedge P4WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRDATA[9]);
    $setuphold (posedge P4CLK, posedge P4WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[0]);
    $setuphold (posedge P4CLK, posedge P4WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[1]);
    $setuphold (posedge P4CLK, posedge P4WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[2]);
    $setuphold (posedge P4CLK, posedge P4WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P4CLK, delay_P4WRMASK[3]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBA[0]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBA[1]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBA[2]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[0]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[1]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[2]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[3]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[4]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[5]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[0]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[10]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[11]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[1]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[2]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[3]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[4]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[5]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[6]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[7]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[8]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[9]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDEN);
    $setuphold (posedge P4CMDCLK, negedge P4CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDINSTR[0]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDINSTR[1]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDINSTR[2]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[0]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[10]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[11]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[12]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[13]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[14]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[1]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[2]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[3]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[4]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[5]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[6]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[7]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[8]);
    $setuphold (posedge P4CMDCLK, negedge P4CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[9]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBA[0]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBA[1]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBA[2]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[0]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[1]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[2]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[3]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[4]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDBL[5]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[0]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[10]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[11]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[1]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[2]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[3]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[4]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[5]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[6]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[7]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[8]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDCA[9]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDEN);
    $setuphold (posedge P4CMDCLK, posedge P4CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDINSTR[0]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDINSTR[1]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDINSTR[2]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[0]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[10]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[11]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[12]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[13]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[14]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[1]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[2]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[3]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[4]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[5]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[6]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[7]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[8]);
    $setuphold (posedge P4CMDCLK, posedge P4CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P4CMDCLK, delay_P4CMDRA[9]);
    $setuphold (posedge P5CLK, negedge P5EN, 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5EN);
    $setuphold (posedge P5CLK, negedge P5WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[0]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[10]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[11]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[12]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[13]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[14]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[15]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[16]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[17]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[18]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[19]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[1]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[20]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[21]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[22]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[23]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[24]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[25]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[26]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[27]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[28]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[29]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[2]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[30]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[31]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[3]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[4]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[5]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[6]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[7]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[8]);
    $setuphold (posedge P5CLK, negedge P5WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[9]);
    $setuphold (posedge P5CLK, negedge P5WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[0]);
    $setuphold (posedge P5CLK, negedge P5WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[1]);
    $setuphold (posedge P5CLK, negedge P5WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[2]);
    $setuphold (posedge P5CLK, negedge P5WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[3]);
    $setuphold (posedge P5CLK, posedge P5EN, 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5EN);
    $setuphold (posedge P5CLK, posedge P5WRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[0]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[10]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[11]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[12]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[13]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[14]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[15]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[16]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[17]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[18]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[19]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[1]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[20]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[21]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[22]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[23]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[24]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[25]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[26]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[27]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[28]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[29]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[2]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[30]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[31]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[3]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[4]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[5]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[6]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[7]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[8]);
    $setuphold (posedge P5CLK, posedge P5WRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRDATA[9]);
    $setuphold (posedge P5CLK, posedge P5WRMASK[0], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[0]);
    $setuphold (posedge P5CLK, posedge P5WRMASK[1], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[1]);
    $setuphold (posedge P5CLK, posedge P5WRMASK[2], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[2]);
    $setuphold (posedge P5CLK, posedge P5WRMASK[3], 0:0:0, 0:0:0, notifier,,, delay_P5CLK, delay_P5WRMASK[3]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBA[0]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBA[1]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBA[2]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[0]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[1]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[2]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[3]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[4]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[5]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[0]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[10]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[11]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[1]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[2]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[3]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[4]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[5]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[6]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[7]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[8]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[9]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDEN);
    $setuphold (posedge P5CMDCLK, negedge P5CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDINSTR[0]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDINSTR[1]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDINSTR[2]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[0]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[10]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[11]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[12]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[13]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[14]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[1]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[2]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[3]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[4]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[5]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[6]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[7]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[8]);
    $setuphold (posedge P5CMDCLK, negedge P5CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[9]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBA[0]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBA[1]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBA[2]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBL[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[0]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBL[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[1]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBL[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[2]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBL[3], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[3]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBL[4], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[4]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDBL[5], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDBL[5]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[0]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[10], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[10]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[11], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[11]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[1]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[2]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[3], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[3]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[4], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[4]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[5], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[5]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[6], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[6]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[7], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[7]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[8], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[8]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDCA[9], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDCA[9]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDEN, 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDEN);
    $setuphold (posedge P5CMDCLK, posedge P5CMDINSTR[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDINSTR[0]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDINSTR[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDINSTR[1]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDINSTR[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDINSTR[2]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[0], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[0]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[10], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[10]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[11], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[11]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[12], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[12]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[13], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[13]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[14], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[14]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[1], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[1]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[2], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[2]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[3], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[3]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[4], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[4]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[5], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[5]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[6], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[6]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[7], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[7]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[8], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[8]);
    $setuphold (posedge P5CMDCLK, posedge P5CMDRA[9], 0:0:0, 0:0:0, notifier,,, delay_P5CMDCLK, delay_P5CMDRA[9]);
    $setuphold (posedge PLLCLK[0], negedge PLLCE[0], 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[0], delay_PLLCE[0]);
    $setuphold (posedge PLLCLK[0], posedge PLLCE[0], 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[0], delay_PLLCE[0]);
    $setuphold (posedge PLLCLK[1], negedge P0ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P0ARBEN);
    $setuphold (posedge PLLCLK[1], negedge P1ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P1ARBEN);
    $setuphold (posedge PLLCLK[1], negedge P2ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P2ARBEN);
    $setuphold (posedge PLLCLK[1], negedge P3ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P3ARBEN);
    $setuphold (posedge PLLCLK[1], negedge P4ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P4ARBEN);
    $setuphold (posedge PLLCLK[1], negedge P5ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P5ARBEN);
    $setuphold (posedge PLLCLK[1], negedge PLLCE[1], 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_PLLCE[1]);
    $setuphold (posedge PLLCLK[1], negedge PLLLOCK, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_PLLLOCK);
    $setuphold (posedge PLLCLK[1], negedge RECAL, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_RECAL);
    $setuphold (posedge PLLCLK[1], posedge P0ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P0ARBEN);
    $setuphold (posedge PLLCLK[1], posedge P1ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P1ARBEN);
    $setuphold (posedge PLLCLK[1], posedge P2ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P2ARBEN);
    $setuphold (posedge PLLCLK[1], posedge P3ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P3ARBEN);
    $setuphold (posedge PLLCLK[1], posedge P4ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P4ARBEN);
    $setuphold (posedge PLLCLK[1], posedge P5ARBEN, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_P5ARBEN);
    $setuphold (posedge PLLCLK[1], posedge PLLCE[1], 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_PLLCE[1]);
    $setuphold (posedge PLLCLK[1], posedge PLLLOCK, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_PLLLOCK);
    $setuphold (posedge PLLCLK[1], posedge RECAL, 0:0:0, 0:0:0, notifier,,, delay_PLLCLK[1], delay_RECAL);
    $setuphold (posedge UICLK, negedge IOIDRPSDI, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_IOIDRPSDI);
    $setuphold (posedge UICLK, negedge UIADD, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADD);
    $setuphold (posedge UICLK, negedge UIADDR[0], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[0]);
    $setuphold (posedge UICLK, negedge UIADDR[1], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[1]);
    $setuphold (posedge UICLK, negedge UIADDR[2], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[2]);
    $setuphold (posedge UICLK, negedge UIADDR[3], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[3]);
    $setuphold (posedge UICLK, negedge UIADDR[4], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[4]);
    $setuphold (posedge UICLK, negedge UIBROADCAST, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIBROADCAST);
    $setuphold (posedge UICLK, negedge UICMD, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICMD);
    $setuphold (posedge UICLK, negedge UICMDEN, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICMDEN);
    $setuphold (posedge UICLK, negedge UICMDIN, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICMDIN);
    $setuphold (posedge UICLK, negedge UICS, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICS);
    $setuphold (posedge UICLK, negedge UIDONECAL, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDONECAL);
    $setuphold (posedge UICLK, negedge UIDQCOUNT[0], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[0]);
    $setuphold (posedge UICLK, negedge UIDQCOUNT[1], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[1]);
    $setuphold (posedge UICLK, negedge UIDQCOUNT[2], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[2]);
    $setuphold (posedge UICLK, negedge UIDQCOUNT[3], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[3]);
    $setuphold (posedge UICLK, negedge UIDQLOWERDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQLOWERDEC);
    $setuphold (posedge UICLK, negedge UIDQLOWERINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQLOWERINC);
    $setuphold (posedge UICLK, negedge UIDQUPPERDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQUPPERDEC);
    $setuphold (posedge UICLK, negedge UIDQUPPERINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQUPPERINC);
    $setuphold (posedge UICLK, negedge UIDRPUPDATE, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDRPUPDATE);
    $setuphold (posedge UICLK, negedge UILDQSDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UILDQSDEC);
    $setuphold (posedge UICLK, negedge UILDQSINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UILDQSINC);
    $setuphold (posedge UICLK, negedge UIREAD, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIREAD);
    $setuphold (posedge UICLK, negedge UISDI, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UISDI);
    $setuphold (posedge UICLK, negedge UIUDQSDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIUDQSDEC);
    $setuphold (posedge UICLK, negedge UIUDQSINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIUDQSINC);
    $setuphold (posedge UICLK, posedge IOIDRPSDI, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_IOIDRPSDI);
    $setuphold (posedge UICLK, posedge UIADD, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADD);
    $setuphold (posedge UICLK, posedge UIADDR[0], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[0]);
    $setuphold (posedge UICLK, posedge UIADDR[1], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[1]);
    $setuphold (posedge UICLK, posedge UIADDR[2], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[2]);
    $setuphold (posedge UICLK, posedge UIADDR[3], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[3]);
    $setuphold (posedge UICLK, posedge UIADDR[4], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIADDR[4]);
    $setuphold (posedge UICLK, posedge UIBROADCAST, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIBROADCAST);
    $setuphold (posedge UICLK, posedge UICMD, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICMD);
    $setuphold (posedge UICLK, posedge UICMDEN, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICMDEN);
    $setuphold (posedge UICLK, posedge UICMDIN, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICMDIN);
    $setuphold (posedge UICLK, posedge UICS, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UICS);
    $setuphold (posedge UICLK, posedge UIDONECAL, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDONECAL);
    $setuphold (posedge UICLK, posedge UIDQCOUNT[0], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[0]);
    $setuphold (posedge UICLK, posedge UIDQCOUNT[1], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[1]);
    $setuphold (posedge UICLK, posedge UIDQCOUNT[2], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[2]);
    $setuphold (posedge UICLK, posedge UIDQCOUNT[3], 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQCOUNT[3]);
    $setuphold (posedge UICLK, posedge UIDQLOWERDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQLOWERDEC);
    $setuphold (posedge UICLK, posedge UIDQLOWERINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQLOWERINC);
    $setuphold (posedge UICLK, posedge UIDQUPPERDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQUPPERDEC);
    $setuphold (posedge UICLK, posedge UIDQUPPERINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDQUPPERINC);
    $setuphold (posedge UICLK, posedge UIDRPUPDATE, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIDRPUPDATE);
    $setuphold (posedge UICLK, posedge UILDQSDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UILDQSDEC);
    $setuphold (posedge UICLK, posedge UILDQSINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UILDQSINC);
    $setuphold (posedge UICLK, posedge UIREAD, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIREAD);
    $setuphold (posedge UICLK, posedge UISDI, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UISDI);
    $setuphold (posedge UICLK, posedge UIUDQSDEC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIUDQSDEC);
    $setuphold (posedge UICLK, posedge UIUDQSINC, 0:0:0, 0:0:0, notifier,,, delay_UICLK, delay_UIUDQSINC);
    ( P0CMDCLK => P0CMDEMPTY) = (100:100:100, 100:100:100);
    ( P0CMDCLK => P0CMDFULL) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[0]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[1]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[2]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[3]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[4]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[5]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDCOUNT[6]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[0]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[10]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[11]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[12]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[13]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[14]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[15]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[16]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[17]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[18]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[19]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[1]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[20]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[21]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[22]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[23]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[24]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[25]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[26]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[27]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[28]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[29]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[2]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[30]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[31]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[3]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[4]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[5]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[6]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[7]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[8]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDDATA[9]) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDEMPTY) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDERROR) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDFULL) = (100:100:100, 100:100:100);
    ( P0RDCLK => P0RDOVERFLOW) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[0]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[1]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[2]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[3]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[4]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[5]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRCOUNT[6]) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WREMPTY) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRERROR) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRFULL) = (100:100:100, 100:100:100);
    ( P0WRCLK => P0WRUNDERRUN) = (100:100:100, 100:100:100);
    ( P1CMDCLK => P1CMDEMPTY) = (100:100:100, 100:100:100);
    ( P1CMDCLK => P1CMDFULL) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[0]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[1]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[2]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[3]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[4]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[5]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDCOUNT[6]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[0]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[10]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[11]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[12]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[13]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[14]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[15]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[16]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[17]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[18]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[19]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[1]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[20]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[21]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[22]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[23]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[24]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[25]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[26]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[27]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[28]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[29]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[2]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[30]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[31]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[3]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[4]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[5]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[6]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[7]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[8]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDDATA[9]) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDEMPTY) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDERROR) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDFULL) = (100:100:100, 100:100:100);
    ( P1RDCLK => P1RDOVERFLOW) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[0]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[1]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[2]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[3]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[4]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[5]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRCOUNT[6]) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WREMPTY) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRERROR) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRFULL) = (100:100:100, 100:100:100);
    ( P1WRCLK => P1WRUNDERRUN) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[0]) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[1]) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[2]) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[3]) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[4]) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[5]) = (100:100:100, 100:100:100);
    ( P2CLK => P2COUNT[6]) = (100:100:100, 100:100:100);
    ( P2CLK => P2EMPTY) = (100:100:100, 100:100:100);
    ( P2CLK => P2ERROR) = (100:100:100, 100:100:100);
    ( P2CLK => P2FULL) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[0]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[10]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[11]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[12]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[13]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[14]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[15]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[16]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[17]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[18]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[19]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[1]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[20]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[21]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[22]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[23]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[24]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[25]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[26]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[27]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[28]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[29]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[2]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[30]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[31]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[3]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[4]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[5]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[6]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[7]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[8]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDDATA[9]) = (100:100:100, 100:100:100);
    ( P2CLK => P2RDOVERFLOW) = (100:100:100, 100:100:100);
    ( P2CLK => P2WRUNDERRUN) = (100:100:100, 100:100:100);
    ( P2CMDCLK => P2CMDEMPTY) = (100:100:100, 100:100:100);
    ( P2CMDCLK => P2CMDFULL) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[0]) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[1]) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[2]) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[3]) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[4]) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[5]) = (100:100:100, 100:100:100);
    ( P3CLK => P3COUNT[6]) = (100:100:100, 100:100:100);
    ( P3CLK => P3EMPTY) = (100:100:100, 100:100:100);
    ( P3CLK => P3ERROR) = (100:100:100, 100:100:100);
    ( P3CLK => P3FULL) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[0]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[10]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[11]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[12]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[13]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[14]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[15]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[16]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[17]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[18]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[19]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[1]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[20]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[21]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[22]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[23]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[24]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[25]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[26]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[27]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[28]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[29]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[2]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[30]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[31]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[3]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[4]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[5]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[6]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[7]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[8]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDDATA[9]) = (100:100:100, 100:100:100);
    ( P3CLK => P3RDOVERFLOW) = (100:100:100, 100:100:100);
    ( P3CLK => P3WRUNDERRUN) = (100:100:100, 100:100:100);
    ( P3CMDCLK => P3CMDEMPTY) = (100:100:100, 100:100:100);
    ( P3CMDCLK => P3CMDFULL) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[0]) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[1]) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[2]) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[3]) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[4]) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[5]) = (100:100:100, 100:100:100);
    ( P4CLK => P4COUNT[6]) = (100:100:100, 100:100:100);
    ( P4CLK => P4EMPTY) = (100:100:100, 100:100:100);
    ( P4CLK => P4ERROR) = (100:100:100, 100:100:100);
    ( P4CLK => P4FULL) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[0]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[10]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[11]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[12]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[13]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[14]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[15]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[16]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[17]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[18]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[19]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[1]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[20]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[21]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[22]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[23]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[24]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[25]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[26]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[27]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[28]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[29]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[2]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[30]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[31]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[3]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[4]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[5]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[6]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[7]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[8]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDDATA[9]) = (100:100:100, 100:100:100);
    ( P4CLK => P4RDOVERFLOW) = (100:100:100, 100:100:100);
    ( P4CLK => P4WRUNDERRUN) = (100:100:100, 100:100:100);
    ( P4CMDCLK => P4CMDEMPTY) = (100:100:100, 100:100:100);
    ( P4CMDCLK => P4CMDFULL) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[0]) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[1]) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[2]) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[3]) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[4]) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[5]) = (100:100:100, 100:100:100);
    ( P5CLK => P5COUNT[6]) = (100:100:100, 100:100:100);
    ( P5CLK => P5EMPTY) = (100:100:100, 100:100:100);
    ( P5CLK => P5ERROR) = (100:100:100, 100:100:100);
    ( P5CLK => P5FULL) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[0]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[10]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[11]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[12]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[13]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[14]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[15]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[16]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[17]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[18]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[19]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[1]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[20]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[21]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[22]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[23]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[24]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[25]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[26]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[27]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[28]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[29]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[2]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[30]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[31]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[3]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[4]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[5]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[6]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[7]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[8]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDDATA[9]) = (100:100:100, 100:100:100);
    ( P5CLK => P5RDOVERFLOW) = (100:100:100, 100:100:100);
    ( P5CLK => P5WRUNDERRUN) = (100:100:100, 100:100:100);
    ( P5CMDCLK => P5CMDEMPTY) = (100:100:100, 100:100:100);
    ( P5CMDCLK => P5CMDFULL) = (100:100:100, 100:100:100);
    ( PLLCLK[0] => DQSIOWEN90N) = (100:100:100, 100:100:100);
    ( PLLCLK[0] => DQSIOWEN90P) = (100:100:100, 100:100:100);
    ( PLLCLK[1] => DQIOWEN0) = (100:100:100, 100:100:100);
    ( PLLCLK[1] => SELFREFRESHMODE) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPADD) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPADDR[0]) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPADDR[1]) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPADDR[2]) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPADDR[3]) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPADDR[4]) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPBROADCAST) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPCLK) = (0:0:0, 0:0:0);
    ( UICLK => IOIDRPCS) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPSDO) = (100:100:100, 100:100:100);
    ( UICLK => IOIDRPUPDATE) = (100:100:100, 100:100:100);
    ( UICLK => UOCALSTART) = (100:100:100, 100:100:100);
    ( UICLK => UOCMDREADYIN) = (100:100:100, 100:100:100);
    ( UICLK => UODATAVALID) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[0]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[1]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[2]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[3]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[4]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[5]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[6]) = (100:100:100, 100:100:100);
    ( UICLK => UODATA[7]) = (100:100:100, 100:100:100);
    ( UICLK => UODONECAL) = (100:100:100, 100:100:100);
    ( UICLK => UOREFRSHFLAG) = (100:100:100, 100:100:100);
    ( UICLK => UOSDO) = (100:100:100, 100:100:100);

    specparam PATHPULSE$ = 0;
  endspecify
endmodule
